/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.web.pages;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.appstatus.core.services.IService;
import net.sf.appstatus.web.HtmlUtils;
import net.sf.appstatus.web.StatusWebHandler;
import net.sf.appstatus.web.pages.AbstractPage;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.text.StrBuilder;

public class ServicesPage
extends AbstractPage {
    private static final String ENCODING = "UTF-8";
    private static final String PAGECONTENTLAYOUT = "servicesContentLayout.html";

    public void doGet(StatusWebHandler webHandler, HttpServletRequest req, HttpServletResponse resp) throws UnsupportedEncodingException, IOException {
        this.setup(resp, "text/html");
        ServletOutputStream os = resp.getOutputStream();
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        List services = webHandler.getAppStatus().getServices();
        Collections.sort(services);
        StrBuilder sbServicesTable = new StrBuilder();
        if (HtmlUtils.generateBeginTable(sbServicesTable, services.size())) {
            HtmlUtils.generateHeaders(sbServicesTable, "", "Group", "Name", "Hits", "Cache", "Running", "min", "max", "avg", "nested", "min (c)", "max (c)", "avg (c)", "nested (c)", "Errors", "Failures", "Hit rate");
            for (IService service : services) {
                HtmlUtils.generateRow(sbServicesTable, "job", StringEscapeUtils.escapeHtml4((String)service.getGroup()), StringEscapeUtils.escapeHtml4((String)service.getName()), service.getHits(), service.getCacheHits() + this.getPercent(service.getCacheHits(), service.getHits()), service.getRunning(), service.getMinResponseTime(), service.getMaxResponseTime(), Math.round(service.getAvgResponseTime()), Math.round(service.getAvgNestedCalls()), service.getMinResponseTimeWithCache(), service.getMaxResponseTimeWithCache(), Math.round(service.getAvgResponseTimeWithCache()), Math.round(service.getAvgNestedCallsWithCache()), service.getErrors() + this.getPercent(service.getErrors(), service.getHits()), service.getFailures() + this.getPercent(service.getFailures(), service.getHits()), this.getRate(service.getCurrentRate()));
            }
            HtmlUtils.generateEndTable(sbServicesTable, services.size());
        }
        valuesMap.put("servicesTable", sbServicesTable.toString());
        String content = HtmlUtils.applyLayout(valuesMap, PAGECONTENTLAYOUT);
        valuesMap.clear();
        valuesMap.put("content", content);
        os.write(this.getPage(webHandler, valuesMap).getBytes(ENCODING));
    }

    public void doPost(StatusWebHandler webHandler, HttpServletRequest req, HttpServletResponse resp) {
    }

    public String getId() {
        return "services";
    }

    public String getName() {
        return "Services";
    }

    private String getPercent(long value1, long value2) {
        if (value2 == 0L) {
            return "(-%)";
        }
        return " (" + 100L * value1 / value2 + "%)";
    }

    private String getRate(double value1) {
        double rate = (double)Math.round(value1 * 100.0) / 100.0;
        return rate + " hits/s";
    }
}

