/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.web.pages;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.appstatus.web.StatusWebHandler;
import org.apache.commons.io.IOUtils;

public class Resources {
    public static final String LOGO = "logo";
    private static Map<String, ResourceDefinition> resources = new HashMap<String, ResourceDefinition>();
    public static final String STATUS_ERROR = "error";
    public static final String STATUS_JOB = "job";
    public static final String STATUS_JOB_ERROR = "job-error";
    public static final String STATUS_JOB_WARNING = "job-warning";
    public static final String STATUS_OK = "ok";
    public static final String STATUS_PROP = "prop";
    public static final String STATUS_WARN = "warn";

    public static void addResource(String id, String location, String mimeType) {
        resources.put(id, new ResourceDefinition(location, mimeType));
    }

    public static void doGet(StatusWebHandler webHandler, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String location = null;
        String id = req.getParameter("resource");
        if (id == null) {
            id = req.getParameter("icon");
        }
        if (resources.containsKey(id)) {
            resp.setContentType(resources.get(id).getMimeType());
            location = resources.get(id).getLocation();
            InputStream is = Resources.class.getResourceAsStream(location);
            IOUtils.copy((InputStream)is, (OutputStream)resp.getOutputStream());
        } else {
            resp.sendError(404);
        }
    }

    static {
        Resources.addResource(STATUS_OK, "/org/freedesktop/tango/22x22/status/weather-clear.png", "image/png");
        Resources.addResource(STATUS_WARN, "/org/freedesktop/tango/22x22/status/weather-overcast.png", "image/png");
        Resources.addResource(STATUS_ERROR, "/org/freedesktop/tango/22x22/status/weather-severe-alert.png", "image/png");
        Resources.addResource(STATUS_PROP, "/org/freedesktop/tango/22x22/actions/format-justify-fill.png", "image/png");
        Resources.addResource(STATUS_JOB, "/org/freedesktop/tango/22x22/emblems/emblem-system.png", "image/png");
        Resources.addResource(STATUS_JOB_ERROR, "/org/freedesktop/tango/22x22/status/dialog-error.png", "image/png");
        Resources.addResource(STATUS_JOB_WARNING, "/org/freedesktop/tango/22x22/status/dialog-warning.png", "image/png");
        Resources.addResource(LOGO, "/assets/img/appstatus-logo.png", "image/png");
    }

    public static class ResourceDefinition {
        private final String location;
        private final String mimeType;

        protected ResourceDefinition(String location, String mimeType) {
            this.location = location;
            this.mimeType = mimeType;
        }

        public String getLocation() {
            return this.location;
        }

        public String getMimeType() {
            return this.mimeType;
        }
    }
}

