/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.web.pages;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.appstatus.core.batch.IBatchManager;
import net.sf.appstatus.core.check.ICheckResult;
import net.sf.appstatus.web.HtmlUtils;
import net.sf.appstatus.web.IPage;
import net.sf.appstatus.web.StatusWebHandler;

public class RadiatorPage
implements IPage {
    private static final int STATUS_ERROR = 2;
    private static final int STATUS_MAINTENANCE = 3;
    private static final int STATUS_OK = 0;
    private static final int STATUS_WARN = 1;

    public void doGet(StatusWebHandler webHandler, HttpServletRequest req, HttpServletResponse resp) throws UnsupportedEncodingException, IOException {
        String btnClass;
        resp.setContentType("text/html");
        resp.setCharacterEncoding("UTF-8");
        List results = webHandler.getAppStatus().checkAll(req.getLocale());
        int status = webHandler.getAppStatus().isMaintenance() ? 3 : 0;
        for (ICheckResult r : results) {
            if (r.getCode() != 0 && !r.isFatal() && status == 0) {
                status = 1;
            }
            if (r.getCode() == 0 || !r.isFatal()) continue;
            status = 2;
            break;
        }
        switch (status) {
            case 1: {
                btnClass = "btn-warning";
                break;
            }
            case 2: {
                btnClass = "btn-danger";
                break;
            }
            case 3: {
                btnClass = "btn-info";
                break;
            }
            default: {
                btnClass = "btn-success";
            }
        }
        IBatchManager manager = webHandler.getAppStatus().getBatchManager();
        String batchStatus = " progress-success ";
        String active = "";
        int width = 0;
        if (manager != null) {
            batchStatus = manager.getErrorBatches().size() > 0 ? " progress-danger " : " progress-success ";
            active = manager.getRunningBatches().size() > 0 ? " progress-striped active " : "";
            width = manager.getRunningBatches().size() + manager.getFinishedBatches().size() > 0 ? 100 : 0;
        }
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("applicationName", webHandler.getApplicationName());
        model.put("batchBtnClass", btnClass);
        model.put("batchStatus", batchStatus);
        model.put("batchActive", active);
        model.put("batchBarWidth", width + "%");
        resp.getWriter().append(HtmlUtils.applyLayout(model, "radiatorLayout.html"));
    }

    public void doPost(StatusWebHandler webHandler, HttpServletRequest req, HttpServletResponse resp) {
    }

    public String getId() {
        return "radiator";
    }

    public String getName() {
        return "Radiator";
    }
}

