/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.web.pages;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.appstatus.core.loggers.LoggerConfig;
import net.sf.appstatus.web.HtmlUtils;
import net.sf.appstatus.web.StatusWebHandler;
import net.sf.appstatus.web.pages.AbstractPage;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggersPage
extends AbstractPage {
    private static final String ENCODING = "UTF-8";
    private static final String LEVEL_ERROR = "ERROR";
    private static final String LEVEL_INFO = "INFO";
    private static final String LEVEL_TRACE = "TRACE";
    private static final String LEVEL_WARN = "WARN";
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggersPage.class);
    private static final String PAGECONTENTLAYOUT = "logContentLayout.html";

    public void doGet(StatusWebHandler webHandler, HttpServletRequest req, HttpServletResponse resp) throws UnsupportedEncodingException, IOException {
        LOGGER.debug("doGet");
        if (StringUtils.isNotBlank((CharSequence)req.getParameter("name")) && StringUtils.isNotBlank((CharSequence)req.getParameter("level"))) {
            LoggerConfig logger2Change = new LoggerConfig(req.getParameter("name"), req.getParameter("level"));
            LOGGER.debug("Change log level : {} - {}", (Object)logger2Change.getName(), (Object)logger2Change.getLevel());
            webHandler.getAppStatus().getLoggersManager().update(logger2Change);
        }
        this.setup(resp, "text/html");
        ServletOutputStream os = resp.getOutputStream();
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        StrBuilder sbLoggersTable = new StrBuilder();
        List loggers = webHandler.getAppStatus().getLoggersManager().getLoggers();
        if (HtmlUtils.generateBeginTable(sbLoggersTable, loggers.size())) {
            HtmlUtils.generateHeaders(sbLoggersTable, "", "Name", "Levels", "", "", "", "");
            for (LoggerConfig logger : loggers) {
                HtmlUtils.generateRow(sbLoggersTable, "prop", logger.getName(), this.getButton(LEVEL_TRACE, logger), this.getButton("DEBUG", logger), this.getButton(LEVEL_INFO, logger), this.getButton(LEVEL_WARN, logger), this.getButton(LEVEL_ERROR, logger));
            }
            HtmlUtils.generateEndTable(sbLoggersTable, loggers.size());
        }
        valuesMap.put("loggersTable", sbLoggersTable.toString());
        valuesMap.put("loggerCount", String.valueOf(loggers.size()));
        String content = HtmlUtils.applyLayout(valuesMap, PAGECONTENTLAYOUT);
        valuesMap.clear();
        valuesMap.put("content", content);
        os.write(this.getPage(webHandler, valuesMap).getBytes(ENCODING));
    }

    public void doPost(StatusWebHandler webHandler, HttpServletRequest req, HttpServletResponse resp) {
    }

    private String getButton(String level, LoggerConfig logger) {
        String buttonTypeTmp = "";
        if (level.equals(logger.getLevel())) {
            if (LEVEL_TRACE.equals(level)) {
                buttonTypeTmp = "btn-info";
            } else if ("DEBUG".equals(level)) {
                buttonTypeTmp = "btn-primary";
            } else if (LEVEL_INFO.equals(level)) {
                buttonTypeTmp = "btn-success";
            } else if (LEVEL_WARN.equals(level)) {
                buttonTypeTmp = "btn-warning";
            } else if (LEVEL_ERROR.equals(level)) {
                buttonTypeTmp = "btn-danger";
            }
        }
        return "<a class='btn btn-mini " + buttonTypeTmp + "' href='?p=loggers&level=" + level + "&name=" + logger.getName() + "'>" + level + "</a>";
    }

    public String getId() {
        return "loggers";
    }

    public String getName() {
        return "Loggers";
    }
}

