/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.web;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.appstatus.core.AppStatus;
import net.sf.appstatus.core.AppStatusStatic;
import net.sf.appstatus.core.IServletContextProvider;
import net.sf.appstatus.web.IPage;
import net.sf.appstatus.web.SpringObjectInstantiationListener;
import net.sf.appstatus.web.StatusWebHandler;
import net.sf.appstatus.web.pages.BatchPage;
import net.sf.appstatus.web.pages.LoggersPage;
import net.sf.appstatus.web.pages.RadiatorPage;
import net.sf.appstatus.web.pages.ServicesPage;
import net.sf.appstatus.web.pages.StatusPage;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusServlet
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(AppStatus.class);
    private static final long serialVersionUID = 3912325072098291029L;
    private static StatusWebHandler statusWeb = null;

    private void addPage(Map<String, IPage> map, IPage page) {
        map.put(page.getId(), page);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        statusWeb.doGet(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        statusWeb.doPost(req, resp);
    }

    public void init(ServletConfig config) throws ServletException {
        AppStatus status;
        super.init(config);
        super.init();
        SpringObjectInstantiationListener instantiation = null;
        String beanName = this.getInitParameter("bean");
        String[] pagesBeanNames = StringUtils.split((String)this.getInitParameter("custom-pages"), (String)", ");
        LinkedHashMap<String, IPage> pages = new LinkedHashMap<String, IPage>();
        if (beanName != null) {
            instantiation = new SpringObjectInstantiationListener(this.getServletContext());
            status = (AppStatus)instantiation.getInstance(beanName);
        } else {
            status = AppStatusStatic.getInstance();
        }
        status.setServletContextProvider(new IServletContextProvider(){

            public ServletContext getServletContext() {
                return StatusServlet.this.getServletContext();
            }
        });
        this.addPage(pages, new StatusPage());
        if (status.getServiceManager() != null) {
            this.addPage(pages, new ServicesPage());
        }
        if (status.getBatchManager() != null) {
            this.addPage(pages, new BatchPage());
        }
        if (status.getLoggersManager() != null) {
            this.addPage(pages, new LoggersPage());
        }
        if (pagesBeanNames != null) {
            for (String pageBean : pagesBeanNames) {
                IPage newPage = null;
                if (instantiation != null && (newPage = (IPage)instantiation.getInstance(pageBean)) == null) {
                    try {
                        newPage = (IPage)Thread.currentThread().getContextClassLoader().loadClass(pageBean).newInstance();
                    }
                    catch (ClassNotFoundException e) {
                        logger.warn("Class {} not found ", (Object)pageBean, (Object)e);
                    }
                    catch (InstantiationException e) {
                        logger.warn("Cannot instanciate {} ", (Object)pageBean, (Object)e);
                    }
                    catch (IllegalAccessException e) {
                        logger.warn("Cannot access class {} for instantiation ", (Object)pageBean, (Object)e);
                    }
                }
                this.addPage(pages, newPage);
            }
        }
        this.addPage(pages, new RadiatorPage());
        statusWeb = new StatusWebHandler();
        statusWeb.setAppStatus(status);
        statusWeb.setApplicationName(StringUtils.defaultString((String)config.getServletContext().getServletContextName(), (String)"No name"));
        statusWeb.setPages(pages);
        statusWeb.init();
    }
}

