/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.web;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.appstatus.core.AppStatus;
import net.sf.appstatus.core.AppStatusStatic;
import net.sf.appstatus.web.IPage;
import net.sf.appstatus.web.pages.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusWebHandler {
    private static Logger logger = LoggerFactory.getLogger(StatusWebHandler.class);
    private String allowIp = null;
    private String applicationName = "";
    private AppStatus appStatus = null;
    private String cssLocation = null;
    private Map<String, IPage> pages = null;

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (this.allowIp != null && !req.getRemoteAddr().equals(this.allowIp)) {
            resp.sendError(401, "IP not authorized");
            return;
        }
        if (req.getParameter("icon") != null || req.getParameter("resource") != null) {
            Resources.doGet(this, req, resp);
            return;
        }
        if (req.getParameter("p") != null && this.pages.containsKey(req.getParameter("p"))) {
            this.pages.get(req.getParameter("p")).doGet(this, req, resp);
        } else {
            this.pages.get("status").doGet(this, req, resp);
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (this.allowIp != null && !req.getRemoteAddr().equals(this.allowIp)) {
            resp.sendError(401, "IP not authorized");
            return;
        }
        if (req.getParameter("p") != null && this.pages.containsKey(req.getParameter("p"))) {
            this.pages.get(req.getParameter("p")).doPost(this, req, resp);
        } else {
            this.pages.get("status").doPost(this, req, resp);
        }
        this.doGet(req, resp);
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public AppStatus getAppStatus() {
        return this.appStatus;
    }

    public String getCssLocation() {
        return this.cssLocation;
    }

    public Map<String, IPage> getPages() {
        return this.pages;
    }

    public void init() {
        if (this.appStatus == null) {
            this.appStatus = AppStatusStatic.getInstance();
        }
        this.appStatus.init();
        try {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("/status-web-conf.properties");
            if (is == null) {
                logger.warn("/status-web-conf.properties not found in classpath. Using default configuration");
            } else {
                Properties p = new Properties();
                p.load(is);
                is.close();
                if (this.allowIp == null) {
                    this.allowIp = (String)p.get("ip.allow");
                }
            }
        }
        catch (Exception e) {
            logger.error("Error loading configuration from /status-web-conf.properties.", (Throwable)e);
        }
        if (this.cssLocation == null) {
            this.cssLocation = "?resource=appstatus.css";
            Resources.addResource("appstatus.css", "/assets/css/appstatus.css", "text/css");
            Resources.addResource("bootstrap.js", "/assets/js/bootstrap.js", "application/javascript");
            Resources.addResource("jquery.js", "/assets/js/jquery-2.0.1.min.js", "application/javascript");
            Resources.addResource("glyphicons-halflings.png", "/assets/img/glyphicons-halflings.png", "image/png");
            Resources.addResource("glyphicons-halflings-white.png", "/assets/img/glyphicons-halflings-white.png", "image/png");
        }
    }

    public void setAllowIp(String allowIp) {
        this.allowIp = allowIp;
    }

    public void setApplicationName(String servletContextName) {
        this.applicationName = servletContextName;
    }

    public void setAppStatus(AppStatus appStatus) {
        this.appStatus = appStatus;
    }

    public void setCssLocation(String cssLocation) {
        this.cssLocation = cssLocation;
    }

    public void setPages(Map<String, IPage> pages) {
        this.pages = pages;
    }
}

