/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.appstatus.core.AppStatus;
import net.sf.appstatus.core.AppStatusStatic;
import net.sf.appstatus.core.IServletContextProvider;
import net.sf.appstatus.core.batch.IBatch;
import net.sf.appstatus.core.check.ICheckResult;
import net.sf.appstatus.core.services.IService;
import net.sf.appstatus.web.SpringObjectInstantiationListener;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class StatusServlet
extends HttpServlet {
    private static final String ENCODING = "UTF-8";
    private static Logger logger = LoggerFactory.getLogger(AppStatus.class);
    private static final long serialVersionUID = 3912325072098291029L;
    private static AppStatus status = null;
    private static final String STATUS_ERROR = "error";
    private static final String STATUS_JOB = "job";
    private static final String STATUS_OK = "ok";
    private static final String STATUS_PROP = "prop";
    private static final String STATUS_WARN = "warn";
    private String allow = null;
    private final String styleSheet = "<style type=\"text/css\" media=\"screen\">table { font-size: 80%; }table ,th, td {  border: 1px solid black; border-collapse:collapse;}th { background-color: #DDDDDD; }</style>";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.allow != null && !req.getRemoteAddr().equals(this.allow)) {
            resp.sendError(401, "IP not authorized");
            return;
        }
        if (req.getParameter("icon") != null) {
            this.doGetResource(req.getParameter("icon"), req, resp);
            return;
        }
        List results = status.checkAll();
        boolean statusOk = true;
        int statusCode = 200;
        for (ICheckResult r : results) {
            if (!r.isFatal()) continue;
            resp.setStatus(500);
            statusCode = 500;
            statusOk = false;
            break;
        }
        resp.setContentType("text/html");
        resp.setCharacterEncoding(ENCODING);
        ServletOutputStream os = resp.getOutputStream();
        os.write("<html><head>".getBytes(ENCODING));
        os.write("<style type=\"text/css\" media=\"screen\">table { font-size: 80%; }table ,th, td {  border: 1px solid black; border-collapse:collapse;}th { background-color: #DDDDDD; }</style>".getBytes(ENCODING));
        os.write("<body>".getBytes(ENCODING));
        os.write("<h1>Status Page</h1>".getBytes(ENCODING));
        os.write(("<p>Online:" + statusOk + "</p>").getBytes(ENCODING));
        os.write(("<p>Code:" + statusCode + "</p>").getBytes(ENCODING));
        os.write("<h2>Status</h2>".getBytes(ENCODING));
        os.write("<table>".getBytes(ENCODING));
        os.write("<tr><th></th><th>Name</th><th>Description</th><th>Code</th><th>Resolution</th></tr>".getBytes(ENCODING));
        for (ICheckResult r : results) {
            this.generateRow(os, this.getStatus(r), r.getProbeName(), r.getDescription(), String.valueOf(r.getCode()), r.getResolutionSteps());
        }
        os.write("</table>".getBytes(ENCODING));
        os.write("<h2>Properties</h2>".getBytes(ENCODING));
        Map properties = status.getProperties();
        os.write("<table>".getBytes(ENCODING));
        os.write("<tr><th></th><th>Category</th><th>Name</th><th>Value</th></tr>".getBytes(ENCODING));
        for (Map.Entry cat : properties.entrySet()) {
            String category = (String)cat.getKey();
            for (Map.Entry r : ((Map)cat.getValue()).entrySet()) {
                this.generateRow(os, STATUS_PROP, category, r.getKey(), r.getValue());
            }
        }
        os.write("</table>".getBytes(ENCODING));
        os.write("<h2>Batchs</h2>".getBytes(ENCODING));
        os.write("<table>".getBytes(ENCODING));
        os.write("<tr><th></th><th>Category</th><th>Name</th><th>Start</th><th>Progress</th><th>End (est.)</th><th>Status</th><th>Task</th><th>Last Msg</th><th>Rejected</th><th>Last Update</th></tr>".getBytes(ENCODING));
        for (IBatch batch : status.getRunningBatches()) {
            this.generateRow(os, STATUS_JOB, batch.getGroup(), batch.getName(), batch.getStartDate(), batch.getProgressStatus() + "%", batch.getEndDate(), batch.getStatus(), batch.getCurrentTask(), batch.getLastMessage(), StringUtils.collectionToCommaDelimitedString((Collection)batch.getRejectedItemsId()), batch.getLastUpdate());
        }
        os.write("</table>".getBytes(ENCODING));
        os.write("<h2>Services</h2>".getBytes(ENCODING));
        os.write("<table>".getBytes(ENCODING));
        os.write("<tr><th></th><th>Category</th><th>Name</th><th>Hits</th><th>Cache</th><th>Running</th><th>min</th><th>max</th><th>avg</th><th>min (Cache)</th><th>max (Cache)</th><th>avg (Cache)</th></tr>".getBytes(ENCODING));
        for (IService service : status.getServices()) {
            this.generateRow(os, STATUS_JOB, service.getGroup(), service.getName(), service.getHits(), service.getCacheHits(), service.getRunning(), service.getMinResponseTime(), service.getMaxResponseTime(), service.getAvgResponseTime(), service.getMinResponseTimeWithCache(), service.getMaxResponseTimeWithCache(), service.getAvgResponseTimeWithCache());
        }
        os.write("</table>".getBytes(ENCODING));
        os.write("</body></html>".getBytes(ENCODING));
    }

    protected void doGetResource(String id, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String location = null;
        if (STATUS_OK.equals(id)) {
            location = "/org/freedesktop/tango/22x22/status/weather-clear.png";
        } else if (STATUS_WARN.equals(id)) {
            location = "/org/freedesktop/tango/22x22/status/weather-overcast.png";
        } else if (STATUS_ERROR.equals(id)) {
            location = "/org/freedesktop/tango/22x22/status/weather-severe-alert.png";
        } else if (STATUS_PROP.equals(id)) {
            location = "/org/freedesktop/tango/22x22/actions/format-justify-fill.png";
        } else if (STATUS_JOB.equals(id)) {
            location = "/org/freedesktop/tango/22x22/categories/preferences-system.png";
        }
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(location);
        ServletOutputStream os = resp.getOutputStream();
        IOUtils.copy((InputStream)is, (OutputStream)os);
    }

    private void generateRow(ServletOutputStream os, String status, Object ... cols) throws IOException {
        os.write("<tr>".getBytes());
        os.write(("<td><img src='?icon=" + status + "'></td>").getBytes(ENCODING));
        for (Object obj : cols) {
            os.write("<td>".getBytes());
            if (obj != null) {
                os.write(obj.toString().getBytes(ENCODING));
            }
            os.write("</td>".getBytes());
        }
        os.write("</tr>".getBytes());
    }

    private String getStatus(ICheckResult result) {
        if (result.isFatal()) {
            return STATUS_ERROR;
        }
        if (result.getCode() == 0) {
            return STATUS_OK;
        }
        return STATUS_WARN;
    }

    public void init() throws ServletException {
        super.init();
        String beanName = null;
        try {
            beanName = this.getInitParameter("bean");
            InputStream is = StatusServlet.class.getResourceAsStream("/status-web-conf.properties");
            if (is == null) {
                logger.warn("/status-web-conf.properties not found in classpath. Using default configuration");
            } else {
                Properties p = new Properties();
                p.load(is);
                is.close();
                this.allow = (String)p.get("ip.allow");
            }
        }
        catch (Exception e) {
            logger.error("Error loading configuration from /status-web-conf.properties.", (Throwable)e);
        }
        status = beanName != null ? (AppStatus)new SpringObjectInstantiationListener(this.getServletContext()).getInstance(beanName) : AppStatusStatic.getInstance();
        status.setServletContextProvider(new IServletContextProvider(){

            public ServletContext getServletContext() {
                return StatusServlet.this.getServletContext();
            }
        });
        status.init();
    }
}

