/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.appstatus.IStatusResult;
import net.sf.appstatus.StatusService;
import net.sf.appstatus.core.IObjectInstantiationListener;
import net.sf.appstatus.web.SpringObjectInstantiationListener;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusServlet
extends HttpServlet {
    private static final String ENCODING = "UTF-8";
    private static Logger logger = LoggerFactory.getLogger(StatusService.class);
    private static final long serialVersionUID = 3912325072098291029L;
    private static StatusService status = null;
    private static final String STATUS_ERROR = "error";
    private static final String STATUS_OK = "ok";
    private static final String STATUS_PROP = "prop";
    private static final String STATUS_WARN = "warn";
    private String allow = null;
    private boolean useSpring = false;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.allow != null && !req.getRemoteAddr().equals(this.allow)) {
            resp.sendError(401, "IP not authorized");
            return;
        }
        if (req.getParameter("icon") != null) {
            this.doGetResource(req.getParameter("icon"), req, resp);
            return;
        }
        List results = status.checkAll();
        boolean statusOk = true;
        int statusCode = 200;
        for (IStatusResult r : results) {
            if (!r.isFatal()) continue;
            resp.setStatus(500);
            statusCode = 500;
            statusOk = false;
            break;
        }
        resp.setContentType("text/html");
        resp.setCharacterEncoding(ENCODING);
        ServletOutputStream os = resp.getOutputStream();
        os.write("<html><body>".getBytes(ENCODING));
        os.write("<h1>Status Page</h1>".getBytes(ENCODING));
        os.write(("<p>Online:" + statusOk + "</p>").getBytes(ENCODING));
        os.write(("<p>Code:" + statusCode + "</p>").getBytes(ENCODING));
        os.write("<h2>Status</h2>".getBytes(ENCODING));
        os.write("<table border='1'>".getBytes(ENCODING));
        os.write("<tr><td></td><td>Name</td><td>Description</td><td>Code</td><td>Resolution</td></tr>".getBytes(ENCODING));
        for (IStatusResult r : results) {
            this.generateRow(os, this.getStatus(r), r.getProbeName(), r.getDescription(), String.valueOf(r.getCode()), r.getResolutionSteps());
        }
        os.write("</table>".getBytes(ENCODING));
        os.write("<h2>Properties</h2>".getBytes(ENCODING));
        Map properties = status.getProperties();
        os.write("<table border='1'>".getBytes(ENCODING));
        os.write("<tr><td></td><td>Category</td><td>Name</td><td>Value</td></tr>".getBytes(ENCODING));
        for (Map.Entry cat : properties.entrySet()) {
            String category = (String)cat.getKey();
            for (Map.Entry r : ((Map)cat.getValue()).entrySet()) {
                this.generateRow(os, STATUS_PROP, category, r.getKey(), r.getValue());
            }
        }
        os.write("</table>".getBytes(ENCODING));
        os.write("</body></html>".getBytes(ENCODING));
    }

    protected void doGetResource(String id, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String location = null;
        if (STATUS_OK.equals(id)) {
            location = "/org/freedesktop/tango/22x22/status/weather-clear.png";
        } else if (STATUS_WARN.equals(id)) {
            location = "/org/freedesktop/tango/22x22/status/weather-overcast.png";
        } else if (STATUS_ERROR.equals(id)) {
            location = "/org/freedesktop/tango/22x22/status/weather-severe-alert.png";
        } else if (STATUS_PROP.equals(id)) {
            location = "/org/freedesktop/tango/22x22/actions/format-justify-fill.png";
        }
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(location);
        ServletOutputStream os = resp.getOutputStream();
        IOUtils.copy((InputStream)is, (OutputStream)os);
    }

    private void generateRow(ServletOutputStream os, String status, Object ... cols) throws IOException {
        os.write("<tr>".getBytes());
        os.write(("<td><img src='?icon=" + status + "'></td>").getBytes(ENCODING));
        for (Object obj : cols) {
            os.write("<td>".getBytes());
            if (obj != null) {
                os.write(obj.toString().getBytes(ENCODING));
            }
            os.write("</td>".getBytes());
        }
        os.write("</tr>".getBytes());
    }

    private String getStatus(IStatusResult result) {
        if (result.isFatal()) {
            return STATUS_ERROR;
        }
        if (result.getCode() == 0) {
            return STATUS_OK;
        }
        return STATUS_WARN;
    }

    public void init() throws ServletException {
        super.init();
        try {
            InputStream is = StatusServlet.class.getResourceAsStream("/status-web-conf.properties");
            if (is == null) {
                logger.warn("/status-web-conf.properties not found in classpath. Using default configuration");
            } else {
                Properties p = new Properties();
                p.load(is);
                is.close();
                this.allow = (String)p.get("ip.allow");
                this.useSpring = Boolean.parseBoolean((String)p.get("useSpring"));
            }
        }
        catch (Exception e) {
            logger.error("Error loading configuration from /status-web-conf.properties.", (Throwable)e);
        }
        status = new StatusService();
        if (this.useSpring) {
            status.setObjectInstanciationListener((IObjectInstantiationListener)new SpringObjectInstantiationListener(this.getServletContext()));
        }
        status.init();
    }
}

