/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.services;

public class CallStatistics {
    private Long maxResponseTime;
    private double avgResponseTime = 0.0;
    private long failures = 0L;
    private long errors = 0L;
    private long hits = 0L;
    private Long minResponseTime;
    private double avgNestedCalls = 0.0;
    private int minMaxDelay;

    public CallStatistics(int minMaxDelay) {
        this.minMaxDelay = minMaxDelay;
    }

    public Long getMaxResponseTime() {
        return this.maxResponseTime;
    }

    public double getAvgResponseTime() {
        return this.avgResponseTime;
    }

    public long getFailures() {
        return this.failures;
    }

    public long getErrors() {
        return this.errors;
    }

    public long getHits() {
        return this.hits;
    }

    public Long getMinResponseTime() {
        return this.minResponseTime;
    }

    public double getAvgNestedCalls() {
        return this.avgNestedCalls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCall(Long executionTime, boolean failure, boolean error, int nestedCalls) {
        CallStatistics callStatistics = this;
        synchronized (callStatistics) {
            ++this.hits;
            if (failure) {
                ++this.failures;
            }
            if (error) {
                ++this.errors;
            }
            if (this.hits > (long)this.minMaxDelay) {
                if (this.maxResponseTime == null || this.maxResponseTime < executionTime) {
                    this.maxResponseTime = executionTime;
                }
                if (this.minResponseTime == null || this.minResponseTime > executionTime) {
                    this.minResponseTime = executionTime;
                }
            }
            this.avgResponseTime = (this.avgResponseTime * (double)(this.hits - 1L) + (double)executionTime.longValue()) / (double)this.hits;
            this.avgNestedCalls = (this.avgNestedCalls * (double)(this.hits - 1L) + (double)nestedCalls) / (double)this.hits;
        }
    }
}

