/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.services;

import net.sf.appstatus.core.services.AbstractLoggingServiceMonitor;
import net.sf.appstatus.core.services.IService;
import net.sf.appstatus.services.Service;

public class ServiceCall
extends AbstractLoggingServiceMonitor {
    String id;
    Service service;
    int nestedCalls = 0;

    public void cacheHit() {
        if (!this.cacheHit) {
            this.service.cacheHits.incrementAndGet();
        }
        super.cacheHit();
    }

    public ServiceCall(Service service, boolean log, boolean useThreadLocal) {
        super((IService)service, log, useThreadLocal);
        this.service = service;
    }

    public String getId() {
        return this.id;
    }

    public void beginCall(Object ... parameters) {
        super.beginCall(parameters);
        this.service.hits.incrementAndGet();
        this.service.running.incrementAndGet();
    }

    public void endCall() {
        if (this.endTime != null) {
            return;
        }
        super.endCall();
        this.service.running.decrementAndGet();
        this.service.addCall(this.executionTime, this.cacheHit, this.failure, this.error, this.nestedCalls);
    }

    public void nestedCall() {
        ++this.nestedCalls;
    }
}

