/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.services;

import java.util.concurrent.atomic.AtomicLong;
import net.sf.appstatus.core.services.IService;
import net.sf.appstatus.services.CachedCallStatistics;
import org.apache.commons.lang3.ObjectUtils;

public class Service
implements IService {
    protected AtomicLong cacheHits = new AtomicLong();
    protected AtomicLong hits = new AtomicLong();
    protected AtomicLong running = new AtomicLong();
    protected String name;
    protected String group;
    private CachedCallStatistics totalStats = new CachedCallStatistics();
    private CachedCallStatistics windowStats = new CachedCallStatistics();
    private CachedCallStatistics windowPrevisiousStats = new CachedCallStatistics();
    private long windowSize = 2000L;
    private long windowStart = 0L;

    public long getRunning() {
        long runningCalls;
        while ((runningCalls = this.running.get()) < 0L) {
            this.running.compareAndSet(runningCalls, 0L);
        }
        return runningCalls;
    }

    public void addCall(Long executionTime, boolean cacheHit, boolean failure, boolean error, int nestedCalls) {
        this.totalStats.addCall(executionTime, cacheHit, failure, error, nestedCalls);
        this.updateWindows();
        this.windowStats.addCall(executionTime, cacheHit, failure, error, nestedCalls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateWindows() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.windowStart > this.windowSize) {
            Service service = this;
            synchronized (service) {
                if (currentTime - this.windowStart > this.windowSize) {
                    this.windowPrevisiousStats = currentTime - this.windowStart <= 2L * this.windowSize ? this.windowStats : new CachedCallStatistics();
                    this.windowStats = new CachedCallStatistics();
                    this.windowStart = currentTime;
                }
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public Double getAvgResponseTime() {
        return this.totalStats.getDirectStatistics().getAvgResponseTime();
    }

    public long getCacheHits() {
        return this.cacheHits.get();
    }

    public long getHits() {
        return this.hits.get();
    }

    public long getFailures() {
        return this.totalStats.getFailures();
    }

    public long getErrors() {
        return this.totalStats.getErrors();
    }

    public Long getMaxResponseTime() {
        return this.totalStats.getDirectStatistics().getMaxResponseTime();
    }

    public Long getMinResponseTime() {
        return this.totalStats.getDirectStatistics().getMinResponseTime();
    }

    public Double getAvgResponseTimeWithCache() {
        return this.totalStats.getCacheStatistics().getAvgResponseTime();
    }

    public Long getMaxResponseTimeWithCache() {
        return this.totalStats.getCacheStatistics().getMaxResponseTime();
    }

    public Long getMinResponseTimeWithCache() {
        return this.totalStats.getCacheStatistics().getMinResponseTime();
    }

    public double getAvgNestedCalls() {
        return this.totalStats.getDirectStatistics().getAvgNestedCalls();
    }

    public double getAvgNestedCallsWithCache() {
        return this.totalStats.getCacheStatistics().getAvgNestedCalls();
    }

    public int compareTo(IService otherService) {
        int groupCompare = ObjectUtils.compare((Comparable)((Object)this.group), (Comparable)((Object)otherService.getGroup()));
        if (groupCompare != 0) {
            return groupCompare;
        }
        return ObjectUtils.compare((Comparable)((Object)this.name), (Comparable)((Object)otherService.getName()));
    }

    public double getCurrentRate() {
        this.updateWindows();
        return (double)(this.windowPrevisiousStats.getTotalHits() * 1000L) / (double)this.windowSize;
    }
}

