/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.services;

import net.sf.appstatus.core.services.AbstractLoggingServiceMonitor;
import net.sf.appstatus.core.services.IService;
import net.sf.appstatus.services.Service;

public class ServiceCall
extends AbstractLoggingServiceMonitor {
    String id;
    Service service;

    public void cacheHit() {
        if (!this.cacheHit) {
            this.service.cacheHits.incrementAndGet();
        }
        super.cacheHit();
    }

    public ServiceCall(Service service, boolean log, boolean useThreadLocal) {
        super((IService)service, log, useThreadLocal);
        this.service = service;
        this.startTime = System.currentTimeMillis();
    }

    public String getId() {
        return this.id;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void beginCall(Object ... parameters) {
        super.beginCall(parameters);
        this.service.hits.incrementAndGet();
        this.service.running.incrementAndGet();
    }

    public void endCall() {
        if (this.endTime != null) {
            return;
        }
        super.endCall();
        this.service.running.decrementAndGet();
        long response = this.endTime - this.startTime;
        if (this.cacheHit) {
            if (this.service.maxResponseTimeWithCache == null || this.service.maxResponseTimeWithCache < response) {
                this.service.maxResponseTimeWithCache = response;
            }
            if (this.service.minResponseTimeWithCache == null || this.service.minResponseTimeWithCache > response) {
                this.service.minResponseTimeWithCache = response;
            }
            this.service.avgResponseTimeWithCache = (this.service.avgResponseTimeWithCache * (double)(this.service.cacheHits.get() - 1L) + (double)response) / (double)this.service.cacheHits.get();
        } else {
            if (this.service.maxResponseTime == null || this.service.maxResponseTime < response) {
                this.service.maxResponseTime = response;
            }
            if (this.service.minResponseTime == null || this.service.minResponseTime > response) {
                this.service.minResponseTime = response;
            }
            this.service.avgResponseTime = (this.service.avgResponseTime * (double)(this.service.hits.get() - this.service.cacheHits.get() - 1L) + (double)response) / (double)(this.service.hits.get() - this.service.cacheHits.get());
        }
        if (this.failure) {
            this.service.failures.incrementAndGet();
        }
        if (this.error) {
            this.service.errors.incrementAndGet();
        }
    }
}

