/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.services;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import net.sf.appstatus.core.services.IService;
import net.sf.appstatus.core.services.IServiceManager;
import net.sf.appstatus.core.services.IServiceMonitor;
import net.sf.appstatus.services.Service;
import net.sf.appstatus.services.ServiceCall;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InProcessServiceManager
implements IServiceManager {
    Properties configuration = null;
    boolean log = true;
    String format = null;
    boolean useThreadLocal = false;
    Hashtable<String, IService> services = new Hashtable();

    public IServiceMonitor getMonitor(IService service) {
        ServiceCall call = new ServiceCall((Service)service, this.log, this.useThreadLocal);
        if (this.format != null) {
            call.setMessageFormat(this.format);
        }
        return call;
    }

    public List<IService> getServices() {
        return new ArrayList<IService>(this.services.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IService getService(String name, String group) {
        IService result = this.services.get(group + "/" + name);
        if (result == null) {
            InProcessServiceManager inProcessServiceManager = this;
            synchronized (inProcessServiceManager) {
                result = this.services.get(group + "/" + name);
                if (result == null) {
                    Service newService = new Service();
                    newService.setName(name);
                    newService.setGroup(group);
                    this.services.put(group + "/" + name, newService);
                    result = newService;
                }
            }
        }
        return result;
    }

    public void setConfiguration(Properties configuration) {
        this.configuration = configuration;
        if (configuration != null) {
            String logEnabled;
            String confLogFormat = configuration.getProperty("services.log.format");
            if (confLogFormat != null) {
                this.format = confLogFormat;
            }
            if ((logEnabled = configuration.getProperty("services.log")) != null) {
                this.log = Boolean.valueOf(logEnabled);
            }
            this.useThreadLocal = Boolean.valueOf(configuration.getProperty("services.useThreadLocal"));
        }
    }
}

