/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.services;

import net.sf.appstatus.core.services.IServiceMonitor;
import net.sf.appstatus.services.Service;

public class ServiceCall
implements IServiceMonitor {
    String id;
    long startTime;
    boolean cacheHit;
    Long endTime = null;
    Service service;
    Object[] parameters;

    public void cacheHit() {
        if (!this.cacheHit) {
            this.cacheHit = true;
            ++this.service.cacheHits;
        }
    }

    public ServiceCall(Service service) {
        this.service = service;
        this.startTime = System.currentTimeMillis();
    }

    public String getId() {
        return this.id;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void beginCall(Object ... parameters) {
        this.parameters = parameters;
        ++this.service.hits;
        ++this.service.running;
    }

    public void endCall() {
        this.endTime = System.currentTimeMillis();
        --this.service.running;
        long response = this.endTime - this.startTime;
        if (this.cacheHit) {
            if (this.service.maxResponseTimeWithCache == null || this.service.maxResponseTimeWithCache < response) {
                this.service.maxResponseTimeWithCache = response;
            }
            if (this.service.minResponseTimeWithCache == null || this.service.minResponseTimeWithCache > response) {
                this.service.minResponseTimeWithCache = response;
            }
            this.service.avgResponseTimeWithCache = (this.service.avgResponseTimeWithCache * (double)(this.service.cacheHits - 1L) + (double)response) / (double)this.service.cacheHits;
        } else {
            if (this.service.maxResponseTime == null || this.service.maxResponseTime < response) {
                this.service.maxResponseTime = response;
            }
            if (this.service.minResponseTime == null || this.service.minResponseTime > response) {
                this.service.minResponseTime = response;
            }
            this.service.avgResponseTime = (this.service.avgResponseTime * (double)(this.service.hits - this.service.cacheHits - 1L) + (double)response) / (double)(this.service.hits - this.service.cacheHits);
        }
    }
}

