/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.core.loggers.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import net.sf.appstatus.core.loggers.ILoggersManager;
import net.sf.appstatus.core.loggers.LoggerConfig;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Log4jLoggersManager
implements ILoggersManager {
    public List<LoggerConfig> getLoggers() {
        ArrayList<LoggerConfig> loggers = new ArrayList<LoggerConfig>();
        loggers.add(new LoggerConfig("ROOT", LogManager.getRootLogger().getEffectiveLevel().toString()));
        Enumeration currentLoggers = LogManager.getCurrentLoggers();
        while (currentLoggers.hasMoreElements()) {
            Logger logger = (Logger)currentLoggers.nextElement();
            loggers.add(new LoggerConfig(logger.getName(), logger.getEffectiveLevel().toString()));
        }
        Collections.sort(loggers);
        return loggers;
    }

    public void update(LoggerConfig logger2Change) {
        if ("ROOT".equals(logger2Change.getName())) {
            LogManager.getRootLogger().setLevel(Level.toLevel((String)logger2Change.getLevel()));
        } else {
            LogManager.getLogger((String)logger2Change.getName()).setLevel(Level.toLevel((String)logger2Change.getLevel()));
        }
    }

    public Properties getConfiguration() {
        return null;
    }

    public void setConfiguration(Properties configuration) {
    }
}

