/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.demo.batch;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.sf.appstatus.core.AppStatusStatic;
import net.sf.appstatus.core.batch.IBatchProgressMonitor;
import net.sf.appstatus.core.services.IServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class BatchSample
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(BatchSample.class);

    public static void main(String[] args) {
        BatchSample batch = new BatchSample();
        batch.run();
    }

    private static List<String> step1(IBatchProgressMonitor stepMonitor) {
        stepMonitor.beginTask("step1", "Create the item list", 100);
        ArrayList<String> items = new ArrayList<String>();
        String item = null;
        int i = 0;
        while (i < 100) {
            IServiceMonitor monitor = AppStatusStatic.getInstance().getServiceMonitor("Dummy service", "dummy");
            monitor.beginCall(new Object[]{"item"});
            item = "item" + i;
            monitor.endCall();
            stepMonitor.setCurrentItem((Object)item);
            if (i % 5 == 0) {
                stepMonitor.reject(item, "Test the reject feature");
            } else {
                try {
                    Thread.sleep(500L);
                    items.add(item);
                    stepMonitor.message(String.valueOf(item) + " item added");
                }
                catch (InterruptedException e) {
                    stepMonitor.reject(item, e.getMessage());
                }
            }
            stepMonitor.worked(1);
            ++i;
        }
        stepMonitor.done();
        return items;
    }

    private static void step2(List<String> items, IBatchProgressMonitor stepMonitor) {
        stepMonitor.beginTask("step2", "Write the items in the console output.", items.size());
        for (String item : items) {
            IServiceMonitor sm = AppStatusStatic.getInstance().getServiceMonitor("Console Write", "Console");
            stepMonitor.message("Writing item : " + item);
            sm.beginCall(null);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            sm.endCall();
            stepMonitor.worked(1);
        }
        stepMonitor.done();
    }

    @Override
    public void run() {
        IBatchProgressMonitor jobMonitor = AppStatusStatic.getInstance().getBatchProgressMonitor("Sample job", "sample", UUID.randomUUID().toString());
        jobMonitor.setLogger(logger);
        jobMonitor.beginTask("sample", "A batch sample", 2);
        List items = BatchSample.step1((IBatchProgressMonitor)jobMonitor.createSubTask(1));
        BatchSample.step2((List)items, (IBatchProgressMonitor)jobMonitor.createSubTask(1));
        jobMonitor.done();
    }
}

