/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.dummy;

import java.net.InetAddress;
import net.sf.appstatus.IStatusResult;
import net.sf.appstatus.check.impl.AbstractStatusChecker;

public class GooglePingStatusChecker
extends AbstractStatusChecker {
    public IStatusResult checkStatus() {
        IStatusResult result = null;
        try {
            InetAddress address = InetAddress.getByName("www.google.com");
            if (!address.isReachable(2000)) {
                throw new Exception("Ping timeout (2000ms)");
            }
            result = this.createResult(0);
            result.setDescription("Google Access ok");
        }
        catch (Exception e) {
            result = this.createResult(1);
            result.setDescription("Google ping failed");
            result.setResolutionSteps("Ping failed. This means that ICMP messages are blocked by this host. (This may not be an issue) " + e.getMessage());
        }
        return result;
    }

    public String getName() {
        return "Google Ping check";
    }
}

