/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.dummy;

import java.net.InetAddress;
import net.sf.appstatus.IStatusChecker;
import net.sf.appstatus.IStatusResult;
import net.sf.appstatus.StatusResultImpl;

public class GooglePingStatusChecker
implements IStatusChecker {
    public IStatusResult checkStatus() {
        StatusResultImpl result = new StatusResultImpl();
        result.setProbeName(this.getName());
        try {
            InetAddress address = InetAddress.getByName("www.google.com");
            if (!address.isReachable(2000)) {
                throw new Exception("Ping timeout (2000ms)");
            }
            result.setDescription("Google Access ok");
            result.setCode(0);
        }
        catch (Exception e) {
            result.setCode(-1);
            result.setDescription("Google ping failed");
            result.setResolutionSteps("Ping failed. This means that ICMP messages are blocked by this host. (This may not be an issue) " + e.getMessage());
            result.setFatal(false);
        }
        return result;
    }

    public String getName() {
        return "Google Ping check";
    }
}

