/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.demo.batch;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.sf.appstatus.core.AppStatus;
import net.sf.appstatus.core.batch.IBatchProgressMonitor;
import net.sf.appstatus.core.services.IServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchSample
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(BatchSample.class);
    private AppStatus appstatus;

    private List<String> step1(IBatchProgressMonitor stepMonitor) {
        stepMonitor.beginTask("step1", "Create the item list", 100);
        ArrayList<String> items = new ArrayList<String>();
        String item = null;
        int i = 0;
        while (i < 100) {
            IServiceMonitor monitor = this.appstatus.getServiceMonitor("Dummy service", "dummy");
            monitor.beginCall(new Object[]{"item"});
            item = "item" + i;
            monitor.endCall();
            stepMonitor.setCurrentItem((Object)item);
            if (i % 5 == 0) {
                stepMonitor.reject(item, "Test the reject feature", null);
            } else {
                try {
                    Thread.sleep(500L);
                    items.add(item);
                    stepMonitor.message(String.valueOf(item) + " item added");
                }
                catch (InterruptedException e) {
                    stepMonitor.reject(item, e.getMessage(), null);
                }
            }
            stepMonitor.worked(1);
            ++i;
        }
        stepMonitor.done();
        return items;
    }

    private void step2(List<String> items, IBatchProgressMonitor stepMonitor) {
        stepMonitor.beginTask("step2", "Write the items in the console output.", items.size());
        for (String item : items) {
            this.appstatus.getServiceMonitor("Console Write", "Console");
            stepMonitor.message("Writing item : " + item);
            stepMonitor.worked(1);
        }
        stepMonitor.done();
    }

    @Override
    public void run() {
        IBatchProgressMonitor jobMonitor = this.appstatus.getBatchProgressMonitor("Sample job", "sample", UUID.randomUUID().toString());
        jobMonitor.setLogger(logger);
        jobMonitor.beginTask("sample", "A batch sample", 2);
        List items = this.step1(jobMonitor.createSubTask(1));
        this.step2(items, jobMonitor.createSubTask(1));
        if (System.currentTimeMillis() % 4L == 0L) {
            jobMonitor.fail("Just to test failure");
        } else {
            jobMonitor.done();
        }
    }

    public void setAppstatus(AppStatus appstatus) {
        this.appstatus = appstatus;
    }
}

