/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.core;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.sf.appstatus.core.IObjectInstantiationListener;
import net.sf.appstatus.core.IServletContextAware;
import net.sf.appstatus.core.IServletContextProvider;
import net.sf.appstatus.core.batch.IBatch;
import net.sf.appstatus.core.batch.IBatchManager;
import net.sf.appstatus.core.batch.IBatchProgressMonitor;
import net.sf.appstatus.core.batch.IBatchScheduleManager;
import net.sf.appstatus.core.check.CheckResultBuilder;
import net.sf.appstatus.core.check.IAppStatusAware;
import net.sf.appstatus.core.check.ICheck;
import net.sf.appstatus.core.check.ICheckResult;
import net.sf.appstatus.core.check.IConfigurationAware;
import net.sf.appstatus.core.loggers.ILoggersManager;
import net.sf.appstatus.core.property.IPropertyProvider;
import net.sf.appstatus.core.services.IService;
import net.sf.appstatus.core.services.IServiceManager;
import net.sf.appstatus.core.services.IServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppStatus
implements Closeable {
    private static final String CONFIG_LOCATION = "status-check.properties";
    private static Logger logger = LoggerFactory.getLogger(AppStatus.class);
    private IBatchManager batchManager = null;
    private IBatchScheduleManager batchScheduleManager;
    protected List<ICheck> checkers;
    private Properties configuration = null;
    protected ExecutorService executorService = null;
    private boolean initDone = false;
    private ILoggersManager loggersManager = null;
    private boolean maintenance = false;
    private String maintenanceFile = null;
    private IObjectInstantiationListener objectInstanciationListener = null;
    private List<IPropertyProvider> propertyProviders;
    private IServiceManager serviceManager = null;
    private IServletContextProvider servletContextProvider = null;

    private void addPropertyProvider(String clazz) {
        IPropertyProvider provider = (IPropertyProvider)this.getClassInstance(clazz);
        if (provider != null) {
            this.propertyProviders.add(provider);
            logger.info("Registered property provider " + clazz);
        } else {
            logger.error("cannot instanciate class {}, Please configure \"{}\" file properly", (Object)clazz, (Object)CONFIG_LOCATION);
        }
    }

    private void addStatusChecker(String clazz) {
        ICheck check = (ICheck)this.getClassInstance(clazz);
        if (check == null) {
            logger.error("cannot instanciate class {}, Please configure \"{}\" file properly", (Object)clazz, (Object)CONFIG_LOCATION);
            return;
        }
        if (check instanceof IServletContextAware) {
            ((IServletContextAware)((Object)check)).setServletContext(this.servletContextProvider.getServletContext());
        }
        this.checkers.add(check);
        logger.info("Registered status checker {}", (Object)clazz);
    }

    public List<ICheckResult> checkAll() {
        return this.checkAll(null);
    }

    public List<ICheckResult> checkAll(final Locale locale) {
        this.checkInit();
        ArrayList<Future<ICheckResult>> statusFutureList = new ArrayList<Future<ICheckResult>>();
        for (final ICheck check : this.checkers) {
            this.injectServletContext(check);
            statusFutureList.add(this.executorService.submit(new Callable<ICheckResult>(){

                @Override
                public ICheckResult call() throws Exception {
                    if (check instanceof IAppStatusAware) {
                        ((IAppStatusAware)((Object)check)).setAppStatus(AppStatus.this);
                    }
                    if (check instanceof IConfigurationAware) {
                        ((IConfigurationAware)((Object)check)).setConfiguration(AppStatus.this.getConfiguration());
                    }
                    return check.checkStatus(locale);
                }
            }));
        }
        ArrayList<ICheckResult> statusList = new ArrayList<ICheckResult>();
        for (int i = 0; i < statusFutureList.size(); ++i) {
            Future f = (Future)statusFutureList.get(i);
            ICheck c = this.checkers.get(i);
            try {
                statusList.add((ICheckResult)f.get());
                continue;
            }
            catch (InterruptedException e) {
                statusList.add(this.createCheckResultFromException(c, e));
                logger.error("", (Throwable)e);
                continue;
            }
            catch (ExecutionException e) {
                statusList.add(this.createCheckResultFromException(c, e));
                logger.error("", (Throwable)e);
            }
        }
        return statusList;
    }

    private void checkInit() {
        if (!this.initDone) {
            logger.warn("Not initialized. Starting init");
            this.init();
        }
    }

    @Override
    public synchronized void close() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }

    private ICheckResult createCheckResultFromException(ICheck c, Exception e) {
        return new CheckResultBuilder().from(c).code(-1).fatal().description("Check failed with exception: " + e.getClass().getCanonicalName() + " " + e.getMessage()).build();
    }

    private boolean existsAndReadable(String filename) {
        return null != filename && new File(filename).canRead();
    }

    public IBatchManager getBatchManager() {
        return this.batchManager;
    }

    public IBatchProgressMonitor getBatchProgressMonitor(String name, String group, String uuid) {
        this.checkInit();
        IBatch batch = null;
        if (this.batchManager != null) {
            batch = this.batchManager.addBatch(name, group, uuid);
            return this.batchManager.getMonitor(batch);
        }
        return null;
    }

    public IBatchScheduleManager getBatchScheduleManager() {
        return this.batchScheduleManager;
    }

    private Object getClassInstance(String className) {
        Object obj = null;
        if (this.objectInstanciationListener != null) {
            obj = this.objectInstanciationListener.getInstance(className);
        }
        if (obj == null) {
            try {
                obj = Thread.currentThread().getContextClassLoader().loadClass(className).newInstance();
            }
            catch (ClassNotFoundException e) {
                logger.warn("Class {} not found ", (Object)className, (Object)e);
            }
            catch (InstantiationException e) {
                logger.warn("Cannot instanciate {} ", (Object)className, (Object)e);
            }
            catch (IllegalAccessException e) {
                logger.warn("Cannot access class {} for instantiation ", (Object)className, (Object)e);
            }
        }
        if (obj == null) {
            try {
                obj = Class.forName(className).newInstance();
                logger.warn("Class {} loaded using a deprecated method. Please report to http://sourceforge.net/apps/mantisbt/appstatus/login_select_proj_page.php?ref=bug_report_page.php", (Object)className);
            }
            catch (ClassNotFoundException e) {
                logger.warn("Class {} not found ", (Object)className, (Object)e);
            }
            catch (InstantiationException e) {
                logger.warn("Cannot instanciate {} ", (Object)className, (Object)e);
            }
            catch (IllegalAccessException e) {
                logger.warn("Cannot access class {} for instantiation ", (Object)className, (Object)e);
            }
        }
        if (obj != null) {
            this.injectServletContext(obj);
        }
        return obj;
    }

    protected Properties getConfiguration() {
        return this.configuration;
    }

    public ILoggersManager getLoggersManager() {
        return this.loggersManager;
    }

    public String getMaintenanceFile() {
        return this.maintenanceFile;
    }

    public Map<String, Map<String, String>> getProperties() {
        this.checkInit();
        TreeMap<String, Map<String, String>> categories = new TreeMap<String, Map<String, String>>();
        for (IPropertyProvider provider : this.propertyProviders) {
            this.injectServletContext(provider);
            if (categories.get(provider.getCategory()) == null) {
                categories.put(provider.getCategory(), new TreeMap());
            }
            Map<String, String> l = categories.get(provider.getCategory());
            l.putAll(provider.getProperties());
        }
        return categories;
    }

    @Deprecated
    public List<IBatch> getRunningBatches() {
        return this.batchManager.getRunningBatches();
    }

    public IServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public IServiceMonitor getServiceMonitor(String name, String group) {
        this.checkInit();
        IService service = null;
        if (this.serviceManager != null) {
            service = this.serviceManager.getService(name, group);
            return this.serviceManager.getMonitor(service);
        }
        return null;
    }

    public List<IService> getServices() {
        if (this.serviceManager == null) {
            return null;
        }
        return this.serviceManager.getServices();
    }

    public IServletContextProvider getServletContext() {
        return this.servletContextProvider;
    }

    public synchronized void init() {
        Properties newConfiguration;
        if (this.initDone) {
            logger.warn("Already initialized");
            return;
        }
        this.executorService = Executors.newCachedThreadPool();
        this.loadPlugins();
        if (this.checkers != null || this.propertyProviders != null || this.configuration != null) {
            logger.info("Configuration is injected : skip loading properties from classpath");
        } else {
            this.checkers = new ArrayList<ICheck>();
            this.propertyProviders = new ArrayList<IPropertyProvider>();
            this.configuration = new Properties();
            try {
                Enumeration<URL> configFiles = Thread.currentThread().getContextClassLoader().getResources(CONFIG_LOCATION);
                if (configFiles == null) {
                    logger.info("config file {} not found in classpath", (Object)CONFIG_LOCATION);
                    return;
                }
                while (configFiles.hasMoreElements()) {
                    Properties p = this.loadProperties(configFiles.nextElement());
                    this.configuration.putAll((Map<?, ?>)p);
                    Set<Object> keys = p.keySet();
                    for (Object oName : keys) {
                        String name = (String)oName;
                        String clazz = (String)p.get(name);
                        if (name.startsWith("check")) {
                            this.addStatusChecker(clazz);
                            continue;
                        }
                        if (name.startsWith("property")) {
                            this.addPropertyProvider(clazz);
                            continue;
                        }
                        logger.debug("Global property  {} : {} ", (Object)name, (Object)clazz);
                    }
                }
            }
            catch (Exception e) {
                logger.error("Initialization error", (Throwable)e);
            }
        }
        if (this.configuration == null) {
            this.configuration = new Properties();
        }
        if (this.getBatchManager() != null) {
            newConfiguration = this.getBatchManager().getConfiguration();
            if (newConfiguration != null) {
                newConfiguration.putAll((Map<?, ?>)this.configuration);
            } else {
                newConfiguration = this.configuration;
            }
            this.getBatchManager().setConfiguration(newConfiguration);
        }
        if (this.getServiceManager() != null) {
            newConfiguration = this.getServiceManager().getConfiguration();
            if (newConfiguration != null) {
                newConfiguration.putAll((Map<?, ?>)this.configuration);
            } else {
                newConfiguration = this.configuration;
            }
            this.getServiceManager().setConfiguration(newConfiguration);
        }
        if (this.getLoggersManager() != null) {
            newConfiguration = this.getLoggersManager().getConfiguration();
            if (newConfiguration != null) {
                newConfiguration.putAll((Map<?, ?>)this.configuration);
            } else {
                newConfiguration = this.configuration;
            }
            this.getLoggersManager().setConfiguration(newConfiguration);
        }
        if (null == this.maintenanceFile) {
            String path = System.getProperty("java.io.tmpdir");
            if (!path.endsWith(File.separator)) {
                path = path + File.separator;
            }
            this.maintenanceFile = path = path + "appstatus-maintenance";
        }
        this.initDone = true;
    }

    private void injectServletContext(Object instance) {
        if (instance instanceof IServletContextAware && this.servletContextProvider != null) {
            ((IServletContextAware)instance).setServletContext(this.servletContextProvider.getServletContext());
        }
    }

    public boolean isMaintenance() {
        return this.maintenance || this.existsAndReadable(this.maintenanceFile);
    }

    private void loadPlugins() {
        int count = 0;
        try {
            Enumeration<URL> plugins = Thread.currentThread().getContextClassLoader().getResources("net/sf/appstatus/plugin.properties");
            while (plugins.hasMoreElements()) {
                String loggersManagerClass;
                String serviceManagerClass;
                URL url = plugins.nextElement();
                logger.info("AppStatus: found plugin: " + url.toString());
                Properties p = this.loadProperties(url);
                String batchManagerClass = p.getProperty("batchManager");
                if (batchManagerClass != null && this.batchManager == null) {
                    this.batchManager = (IBatchManager)this.getClassInstance(batchManagerClass);
                }
                if ((serviceManagerClass = p.getProperty("serviceManager")) != null && this.serviceManager == null) {
                    this.serviceManager = (IServiceManager)this.getClassInstance(serviceManagerClass);
                }
                if ((loggersManagerClass = p.getProperty("loggersManager")) != null && this.loggersManager == null) {
                    this.loggersManager = (ILoggersManager)this.getClassInstance(loggersManagerClass);
                }
                ++count;
            }
        }
        catch (IOException e) {
            logger.warn("AppStatus: Error loading plugins", (Throwable)e);
        }
        logger.info("AppStatus: found {} plugins", (Object)count);
    }

    private Properties loadProperties(URL url) throws IOException {
        Properties p = new Properties();
        InputStream is = url.openStream();
        p.load(is);
        is.close();
        return p;
    }

    public void setBatchManager(IBatchManager batchManager) {
        this.batchManager = batchManager;
    }

    public void setBatchScheduleManager(IBatchScheduleManager batchScheduleManager) {
        this.batchScheduleManager = batchScheduleManager;
    }

    public void setCheckers(List<ICheck> checkers) {
        this.checkers = checkers;
    }

    public void setConfiguration(Properties configuration) {
        this.configuration = configuration;
    }

    public void setMaintenance(boolean maintenanceMode) throws IOException {
        this.maintenance = maintenanceMode;
        if (null == this.maintenanceFile) {
            return;
        }
        File modeFile = new File(this.maintenanceFile);
        if (maintenanceMode) {
            modeFile.createNewFile();
        } else if (modeFile.exists() && !modeFile.delete()) {
            throw new IOException("Unable to delete maintenance file");
        }
    }

    public void setMaintenanceFile(String maintenanceModeFile) {
        this.maintenanceFile = maintenanceModeFile;
    }

    public void setObjectInstanciationListener(IObjectInstantiationListener objectInstanciationListener) {
        this.objectInstanciationListener = objectInstanciationListener;
    }

    public void setPropertyProviders(List<IPropertyProvider> propertyProviders) {
        this.propertyProviders = propertyProviders;
    }

    public void setServiceManager(IServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    public void setServletContextProvider(IServletContextProvider servletContext) {
        this.servletContextProvider = servletContext;
    }
}

