/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.core.services;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.sf.appstatus.core.services.AbstractServiceMonitor;
import net.sf.appstatus.core.services.IService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLoggingServiceMonitor
extends AbstractServiceMonitor {
    private static Logger stdLogger = LoggerFactory.getLogger(AbstractLoggingServiceMonitor.class);
    protected boolean cacheHit = false;
    protected Map<String, String> context = null;
    protected String correlationId = null;
    private final boolean enableLog;
    protected Long endTime = null;
    protected boolean error = false;
    protected String errorMessage = null;
    protected Long executionTime = null;
    protected boolean failure = false;
    protected Exception failureException = null;
    protected String failureReason = null;
    private Logger logger = null;
    private String messageFormat = "${correlationId}|${group}|${name}|${responseTime}|${cache}|${status}|${statusMessage}";
    protected Object[] parameters;
    private final IService service;
    protected long startTime;

    public AbstractLoggingServiceMonitor(IService service, boolean enableLog, boolean useThreadLocal) {
        super(useThreadLocal);
        this.service = service;
        this.enableLog = enableLog;
        this.startTime = System.currentTimeMillis();
    }

    public void beginCall(Object ... parameters) {
        super.beginCall(parameters);
        this.parameters = parameters;
    }

    public void cacheHit() {
        if (!this.cacheHit) {
            this.cacheHit = true;
        }
    }

    public void context(String name, String value) {
        if (this.context == null) {
            this.context = new HashMap<String, String>();
        }
        this.context.put(name, value);
    }

    public void correlationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public void endCall() {
        Logger log;
        if (this.endTime != null) {
            return;
        }
        super.endCall();
        this.endTime = System.currentTimeMillis();
        if (this.executionTime == null) {
            this.executionTime = this.endTime - this.startTime;
        }
        if (this.enableLog && (log = this.getLogger()).isInfoEnabled()) {
            log.info(this.getLogMessage());
        }
    }

    public void error(String message) {
        this.error = true;
        this.errorMessage = message;
    }

    public void executionTime(long timeMillis) {
        this.executionTime = timeMillis;
    }

    public void failure(String reason) {
        this.failure(reason, null);
    }

    public void failure(String reason, Exception e) {
        this.failure = true;
        this.failureReason = reason;
        this.failureException = e;
    }

    protected Logger getLogger() {
        if (this.logger != null) {
            return this.logger;
        }
        return stdLogger;
    }

    protected String getLogMessage() {
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        valuesMap.put("responseTime", String.valueOf(this.executionTime));
        valuesMap.put("group", this.service.getGroup());
        valuesMap.put("name", this.service.getName());
        valuesMap.put("cache", this.cacheHit ? "HIT" : "MISS");
        valuesMap.put("failure", this.failure ? "FAILURE" : "");
        valuesMap.put("failureReason", StringUtils.defaultString((String)this.failureReason));
        valuesMap.put("failureException", this.failureException != null ? this.failureException.getLocalizedMessage() : "");
        valuesMap.put("error", this.error ? "ERROR" : "");
        valuesMap.put("errorMessage", StringUtils.defaultString((String)this.errorMessage));
        valuesMap.put("correlationId", StringUtils.defaultString((String)this.correlationId));
        if (this.context != null) {
            Set<String> keys = this.context.keySet();
            for (String key : keys) {
                valuesMap.put(key, this.context.get(key));
            }
        }
        String status = "SUCCESS";
        String statusMessage = "";
        if (this.error) {
            status = "ERROR";
            statusMessage = this.errorMessage;
        }
        if (this.failure) {
            status = "FAILURE";
            statusMessage = this.failureReason;
        }
        valuesMap.put("status", status);
        valuesMap.put("statusMessage", statusMessage);
        StrSubstitutor sub = new StrSubstitutor(valuesMap);
        return sub.replace(this.messageFormat);
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setLogFormat(String messageFormat) {
        this.messageFormat = messageFormat;
    }

    public void setLogger(Logger l) {
        this.logger = l;
    }

    @Deprecated
    public void setMessageFormat(String messageFormat) {
        this.setLogFormat(messageFormat);
    }
}

