/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.core.check.impl;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.Locale;
import java.util.Properties;
import net.sf.appstatus.core.check.AbstractCheck;
import net.sf.appstatus.core.check.CheckResultBuilder;
import net.sf.appstatus.core.check.ICheckResult;

public class JvmCheck
extends AbstractCheck {
    private int limitError = 95;
    private int limitWarn = 80;

    public ICheckResult checkStatus(Locale locale) {
        MemoryMXBean memory = ManagementFactory.getMemoryMXBean();
        MemoryUsage heap = memory.getHeapMemoryUsage();
        long heapRatio = heap.getUsed() * 100L / heap.getMax();
        CheckResultBuilder result = this.result(this).messageBundle("net.sf.appstatus.core.check.impl.JvmCheck_msg", locale);
        if (heapRatio > (long)this.limitError) {
            result.code(-1).fatal().resolutionSteps("resolutionSteps.fatal", new Object[0]);
        } else if (heapRatio > (long)this.limitWarn) {
            result.code(-1).resolutionSteps("resolutionSteps.warn", new Object[0]);
        } else {
            result.code(0);
        }
        result.description("description", heapRatio);
        return result.build();
    }

    public String getGroup() {
        return "JVM";
    }

    public String getName() {
        return "Heap usage";
    }

    public void setConfiguration(Properties configuration) {
        String warn;
        super.setConfiguration(configuration);
        String error = this.getConfiguration().getProperty("jvmCheck.limitError");
        if (error != null) {
            this.limitError = Integer.valueOf(error);
        }
        if ((warn = this.getConfiguration().getProperty("jvmCheck.limitWarn")) != null) {
            this.limitWarn = Integer.valueOf(warn);
        }
    }
}

