/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.support.aop;

import net.sf.appstatus.core.services.IService;
import net.sf.appstatus.core.services.IServiceManager;
import net.sf.appstatus.core.services.IServiceMonitor;
import net.sf.appstatus.support.aop.IAppStatusActivationCallback;
import net.sf.appstatus.support.aop.IPostServiceCallback;
import net.sf.appstatus.support.aop.IPreServiceCallback;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppStatusServiceInterceptor
implements MethodInterceptor {
    private IAppStatusActivationCallback activationCallback;
    private Logger logger = null;
    private IPostServiceCallback postServiceCallback;
    private IPreServiceCallback preServiceCallback;
    private IServiceManager serviceManager;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (this.activationCallback != null && !this.activationCallback.isActive(invocation)) {
            return invocation.proceed();
        }
        IServiceMonitor m = null;
        if (this.preServiceCallback != null) {
            m = this.preServiceCallback.getMonitor(this.serviceManager, invocation);
        }
        if (m == null) {
            IService service = this.serviceManager.getService(invocation.getMethod().getName(), invocation.getThis().getClass().getSimpleName());
            m = this.serviceManager.getMonitor(service);
        }
        if (this.logger != null) {
            m.setLogger(this.logger);
        }
        if (this.preServiceCallback != null) {
            this.preServiceCallback.setup(m, invocation);
        }
        Object result = null;
        m.beginCall(invocation.getArguments());
        try {
            result = invocation.proceed();
            if (this.postServiceCallback != null) {
                this.postServiceCallback.handleResult(m, invocation, result);
            }
        }
        catch (Exception e) {
            if (this.postServiceCallback != null) {
                this.postServiceCallback.handleException(m, invocation, e);
            } else {
                m.failure(e.getLocalizedMessage(), e);
            }
            throw e;
        }
        finally {
            m.endCall();
        }
        return result;
    }

    public void setActivationCallback(IAppStatusActivationCallback activationCallback) {
        this.activationCallback = activationCallback;
    }

    public void setLogger(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
    }

    public void setPostServiceCallback(IPostServiceCallback postServiceCallback) {
        this.postServiceCallback = postServiceCallback;
    }

    public void setPreServiceCallback(IPreServiceCallback preServiceCallback) {
        this.preServiceCallback = preServiceCallback;
    }

    public void setServiceManager(IServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }
}

