/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.core.check.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.sf.appstatus.core.AppStatus;
import net.sf.appstatus.core.check.AbstractCheck;
import net.sf.appstatus.core.check.IAppStatusAware;
import net.sf.appstatus.core.check.ICheckResult;
import net.sf.appstatus.core.services.IService;
import org.apache.commons.lang3.StringUtils;

public class ServicesFailureCheck
extends AbstractCheck
implements IAppStatusAware {
    private AppStatus appStatus;
    private int limitError = 10;
    private int limitWarn = 5;

    public ICheckResult checkStatus() {
        List<IService> services = this.appStatus.getServiceManager().getServices();
        ArrayList<String> warns = new ArrayList<String>();
        ArrayList<String> errors = new ArrayList<String>();
        for (IService s : services) {
            if (s.getHits() == 0L) continue;
            long failureRatio = s.getFailures() * 100L / s.getHits();
            if (failureRatio > (long)this.limitError) {
                errors.add("Service <b>" + s.getGroup() + "#" + s.getName() + "</b> failure ratio (" + failureRatio + "%) is over error limit (" + this.limitError + "%)");
                continue;
            }
            if (failureRatio <= (long)this.limitWarn) continue;
            warns.add("Service <b>" + s.getGroup() + "#" + s.getName() + "</b> failure ratio (" + failureRatio + "%) is over warn limit (" + this.limitWarn + "%)");
        }
        ICheckResult result = null;
        if (errors.size() > 0) {
            String description = StringUtils.join(errors, (String)"<br/>");
            if (warns.size() > 0) {
                description = description + " <br/>Additional warnings: " + StringUtils.join(warns, (String)"<br/>");
            }
            result = this.result(this).code(-1).fatal().description(description).build();
        } else {
            result = warns.size() > 0 ? this.result(this).code(-1).description(StringUtils.join(warns, (String)"<br/>")).build() : this.result(this).code(0).description("All failure ratios under " + this.limitWarn + "%").build();
        }
        return result;
    }

    public String getGroup() {
        return "Services";
    }

    public String getName() {
        return "Failures";
    }

    public void setAppStatus(AppStatus appStatus) {
        this.appStatus = appStatus;
    }

    public void setConfiguration(Properties configuration) {
        String warn;
        super.setConfiguration(configuration);
        String error = this.getConfiguration().getProperty("serviceFailureCheck.limitError");
        if (error != null) {
            this.limitError = Integer.valueOf(error);
        }
        if ((warn = this.getConfiguration().getProperty("serviceFailureCheck.limitWarn")) != null) {
            this.limitWarn = Integer.valueOf(warn);
        }
    }
}

