/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.core.check.impl;

import java.util.ArrayList;
import java.util.List;
import net.sf.appstatus.core.AppStatus;
import net.sf.appstatus.core.check.AbstractCheck;
import net.sf.appstatus.core.check.IAppStatusAware;
import net.sf.appstatus.core.check.ICheckResult;
import net.sf.appstatus.core.services.IService;
import org.apache.commons.lang3.StringUtils;

public class ServicesPerformanceCheck
extends AbstractCheck
implements IAppStatusAware {
    private AppStatus appStatus;
    private int limitError = 3000;
    private int limitWarn = 1000;

    public ICheckResult checkStatus() {
        List<IService> services = this.appStatus.getServiceManager().getServices();
        ArrayList<String> warns = new ArrayList<String>();
        ArrayList<String> errors = new ArrayList<String>();
        for (IService s : services) {
            if (s.getAvgResponseTime() > (double)this.limitError || s.getAvgResponseTimeWithCache() > (double)this.limitError) {
                errors.add("Service <b>" + s.getGroup() + "#" + s.getName() + "</b> average response time (" + Math.round(s.getAvgResponseTime()) + "ms without cache / " + Math.round(s.getAvgNestedCallsWithCache()) + "ms with cache) is over error limit (" + this.limitError + "ms)");
                continue;
            }
            if (!(s.getAvgResponseTime() > (double)this.limitWarn) && !(s.getAvgResponseTimeWithCache() > (double)this.limitWarn)) continue;
            warns.add("Service <b>" + s.getGroup() + "#" + s.getName() + "</b> average response time (" + Math.round(s.getAvgResponseTime()) + "ms without cache /" + Math.round(s.getAvgNestedCallsWithCache()) + "ms with cache) is over warn limit (" + this.limitWarn + "ms)");
        }
        ICheckResult result = null;
        if (errors.size() > 0) {
            String description = StringUtils.join(errors, (String)"<br/>");
            if (warns.size() > 0) {
                description = description + " <br/>Additional warnings: " + StringUtils.join(warns, (String)"<br/>");
            }
            result = this.result(this).code(-1).fatal().description(description).build();
        } else {
            result = warns.size() > 0 ? this.result(this).code(-1).description(StringUtils.join(warns, (String)"<br/>")).build() : this.result(this).code(0).description("All average times under " + this.limitWarn + "ms").build();
        }
        return result;
    }

    public String getGroup() {
        return "Services";
    }

    public String getName() {
        return "Performance";
    }

    public void setAppStatus(AppStatus appStatus) {
        this.appStatus = appStatus;
    }

    public void setLimitError(int limitError) {
        this.limitError = limitError;
    }

    public void setLimitWarn(int limitWarn) {
        this.limitWarn = limitWarn;
    }
}

