/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.core.check.impl;

import java.util.ArrayList;
import java.util.List;
import net.sf.appstatus.core.AppStatus;
import net.sf.appstatus.core.check.AbstractCheck;
import net.sf.appstatus.core.check.IAppStatusAware;
import net.sf.appstatus.core.check.ICheckResult;
import net.sf.appstatus.core.services.IService;
import org.apache.commons.lang3.StringUtils;

public class ServicesFailureCheck
extends AbstractCheck
implements IAppStatusAware {
    private AppStatus appStatus;
    private final int limitError = 10;
    private final int limitWarn = 5;

    public ICheckResult checkStatus() {
        List<IService> services = this.appStatus.getServiceManager().getServices();
        ArrayList warns = new ArrayList();
        ArrayList<String> errors = new ArrayList<String>();
        for (IService s : services) {
            if (s.getHits() == 0L) continue;
            long failureRatio = s.getFailures() * 100L / s.getHits();
            if (failureRatio > 10L) {
                errors.add("Service " + s.getGroup() + "-" + s.getName() + " failure ratio (" + failureRatio + ") is over error limit (" + 10 + ")");
                continue;
            }
            if (failureRatio <= 5L) continue;
            errors.add("Service " + s.getGroup() + "-" + s.getName() + " failure ratio (" + failureRatio + ") is over error limit (" + 5 + ")");
        }
        ICheckResult result = null;
        result = errors.size() > 0 ? this.result(this).code(-1).description(StringUtils.join(errors, (String)"<br/>") + " <br/>Additional warnings: " + StringUtils.join(warns, (String)"<br/>")).build() : (warns.size() > 0 ? this.result(this).code(-1).description(StringUtils.join(warns, (String)"<br/>")).build() : this.result(this).code(0).description("All failure ratios under 5%").build());
        return result;
    }

    public String getGroup() {
        return "Services";
    }

    public String getName() {
        return "Failures";
    }

    public void setAppStatus(AppStatus appStatus) {
        this.appStatus = appStatus;
    }
}

