/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.core.check;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import net.sf.appstatus.core.check.ICheck;
import net.sf.appstatus.core.check.ICheckResult;
import net.sf.appstatus.core.check.impl.StatusResultImpl;

public class CheckResultBuilder {
    int code;
    private Object[] descriptionArgs;
    boolean fatal = false;
    private Locale locale;
    String name;
    String group;
    String description;
    String resolutionSteps;
    String bundle = null;
    private Object[] resolutionStepArgs;

    public ICheckResult build() {
        ResourceBundle resBundle = null;
        if (this.bundle != null) {
            resBundle = ResourceBundle.getBundle(this.bundle, this.locale);
        }
        StatusResultImpl result = new StatusResultImpl();
        result.setGroup(resBundle != null ? resBundle.getString(this.group) : this.group);
        result.setProbeName(resBundle != null ? resBundle.getString(this.name) : this.name);
        result.setCode(this.code);
        result.setFatal(this.code == 0 ? false : this.fatal);
        if ((this.resolutionStepArgs != null || this.descriptionArgs != null) && this.bundle == null) {
            throw new IllegalStateException("messageBundle() must be set when using messages with args.");
        }
        if (this.bundle != null) {
            result.setDescription(MessageFormat.format(resBundle.getString(this.description), this.descriptionArgs));
        } else {
            result.setDescription(this.description);
        }
        if (this.bundle != null) {
            result.setDescription(MessageFormat.format(resBundle.getString(this.resolutionSteps), this.resolutionStepArgs));
        } else {
            result.setResolutionSteps(this.resolutionSteps);
        }
        return result;
    }

    public CheckResultBuilder code(int code) {
        this.code = code;
        return this;
    }

    public CheckResultBuilder description(String description) {
        this.description = description;
        return this;
    }

    public CheckResultBuilder description(String description, Object ... args) {
        this.description = description;
        this.descriptionArgs = args;
        return this;
    }

    public CheckResultBuilder fatal() {
        this.fatal = true;
        return this;
    }

    public CheckResultBuilder from(ICheck check) {
        this.name = check.getName();
        this.group = check.getGroup();
        return this;
    }

    public CheckResultBuilder messageBundle(String bundle, Locale locale) {
        this.bundle = bundle;
        this.locale = locale;
        return this;
    }

    public CheckResultBuilder resolutionSteps(String resolutionSteps) {
        this.resolutionSteps = resolutionSteps;
        return this;
    }

    public CheckResultBuilder resolutionSteps(String resolutionSteps, Object ... args) {
        this.resolutionSteps = resolutionSteps;
        this.resolutionStepArgs = args;
        return this;
    }
}

