/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.core.check.impl;

import java.util.ArrayList;
import java.util.List;
import net.sf.appstatus.core.AppStatus;
import net.sf.appstatus.core.check.AbstractCheck;
import net.sf.appstatus.core.check.IAppStatusAware;
import net.sf.appstatus.core.check.ICheckResult;
import net.sf.appstatus.core.services.IService;

public class ServicesPerformanceCheck
extends AbstractCheck
implements IAppStatusAware {
    private AppStatus appStatus;
    private final int limitError = 3000;
    private final int limitWarn = 1000;

    public ICheckResult checkStatus() {
        List<IService> services = this.appStatus.getServiceManager().getServices();
        ArrayList<String> warns = new ArrayList<String>();
        ArrayList<String> errors = new ArrayList<String>();
        for (IService s : services) {
            if (s.getAvgResponseTime() > 3000.0 || s.getAvgResponseTimeWithCache() > 3000.0) {
                errors.add("Service " + s.getGroup() + "-" + s.getName() + " average response time (" + s.getAvgResponseTime() + "/" + s.getAvgNestedCallsWithCache() + "cached) is over error limit (" + 3000 + ")");
                continue;
            }
            if (!(s.getAvgResponseTime() > 1000.0) && !(s.getAvgResponseTimeWithCache() > 1000.0)) continue;
            warns.add("Service " + s.getGroup() + "-" + s.getName() + " average response time (" + s.getAvgResponseTime() + "/" + s.getAvgNestedCallsWithCache() + "cached) is over warn limit (" + 1000 + ")");
        }
        ICheckResult result = null;
        if (errors.size() > 0) {
            result = this.createResult(2);
        } else if (warns.size() > 0) {
            result = this.createResult(1);
        } else {
            result = this.createResult(0);
            result.setDescription("All average times under 1000ms");
        }
        return result;
    }

    public String getGroup() {
        return "Performance";
    }

    public String getName() {
        return "Services";
    }

    public void setAppStatus(AppStatus appStatus) {
        this.appStatus = appStatus;
    }
}

