/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.core.check.impl;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import net.sf.appstatus.core.check.AbstractCheck;
import net.sf.appstatus.core.check.ICheckResult;

public class JvmCheck
extends AbstractCheck {
    public ICheckResult checkStatus() {
        MemoryMXBean memory = ManagementFactory.getMemoryMXBean();
        MemoryUsage heap = memory.getHeapMemoryUsage();
        long heapRatio = heap.getUsed() * 100L / heap.getMax();
        ICheckResult result = null;
        if (heapRatio > 95L) {
            result = this.createResult(2);
            result.setResolutionSteps("Increase memory allocation (JVM arg -Xmx) or reduce memory usage in application code.");
        } else if (heapRatio > 80L) {
            result = this.createResult(1);
            result.setResolutionSteps("Monitor closely memory usage and increase memory allocation (JVM arg -Xmx) if necessary");
        } else {
            result = this.createResult(0);
        }
        result.setDescription("Using " + heapRatio + "% of maximum memory (Heap).");
        return result;
    }

    public String getGroup() {
        return "JVM";
    }

    public String getName() {
        return "Heap usage";
    }
}

