/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.core.batch;

import java.util.Date;
import java.util.List;
import java.util.Vector;
import net.sf.appstatus.core.batch.IBatch;
import net.sf.appstatus.core.batch.IBatchProgressMonitor;
import net.sf.appstatus.core.batch.IBatchProgressMonitorExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBatchProgressMonitor
implements IBatchProgressMonitorExt {
    private final IBatch batch;
    protected List<AbstractBatchProgressMonitor> currentChildren;
    protected Object currentItem;
    protected boolean done = false;
    protected Long endTime = null;
    protected final String executionId;
    protected long itemCount = 0L;
    private String lastMessage;
    private long lastUpdate = -1L;
    private long lastWriteTimestamp;
    private Logger logger = LoggerFactory.getLogger((String)"Batch");
    private String name;
    protected AbstractBatchProgressMonitor parent;
    private int parentWork;
    protected final List<String> rejectedItems = new Vector<String>();
    protected long startTime;
    private boolean success;
    protected final List<String> successItems = new Vector<String>();
    private String taskDescription;
    private String taskGroup;
    protected String taskName = null;
    protected int totalWork = -1;
    protected int worked = 0;
    private long writingDelay = 1000L;

    public AbstractBatchProgressMonitor(String executionId, IBatch batch) {
        this.executionId = executionId;
        this.batch = batch;
        this.currentChildren = new Vector<AbstractBatchProgressMonitor>();
        this.batch.setProgressMonitor(this);
        this.startTime = System.currentTimeMillis();
        this.getLogger().info("[{}] {}: Init progress monitoring (id: {})", new Object[]{this.batch.getGroup(), batch.getName(), batch.getUuid()});
        this.touch();
    }

    protected AbstractBatchProgressMonitor(String executionId, IBatchProgressMonitor parent, int parentWork, IBatch batch) {
        this.executionId = executionId;
        this.parent = (AbstractBatchProgressMonitor)parent;
        this.parentWork = parentWork;
        this.currentChildren = new Vector<AbstractBatchProgressMonitor>();
        this.batch = batch;
        this.startTime = System.currentTimeMillis();
        this.touch();
    }

    @Override
    public void beginTask(String name, String description, int totalWork) {
        if (this.taskName != null) {
            throw new IllegalStateException("beginTask can only be called once (" + name + ", " + description + ", " + totalWork + ")");
        }
        this.totalWork = totalWork;
        this.taskName = name;
        this.taskDescription = description;
        this.getLogger().info("[{}] {}: Begin {} ({}), steps : {}", new Object[]{this.getBatch().getGroup(), this.getBatch().getName(), name, description, String.valueOf(totalWork)});
        this.touch();
    }

    @Override
    public IBatchProgressMonitor createSubTask(int work) {
        AbstractBatchProgressMonitor newSubTask = (AbstractBatchProgressMonitor)this.newInstance(work);
        this.currentChildren.add(newSubTask);
        this.touch();
        return newSubTask;
    }

    @Override
    public void done() {
        if (this.parent != null) {
            this.endTask(true);
            this.getLogger().info("[{}] {}: End {}, {} ms", new Object[]{this.getBatch().getGroup(), this.getBatch().getName(), this.name, System.currentTimeMillis() - this.startTime});
        } else {
            this.endBatch(true);
            this.getLogger().info("[{}] {}: End batch, {} ms", new Object[]{this.getBatch().getGroup(), this.getBatch().getName(), System.currentTimeMillis() - this.startTime});
        }
        this.touch();
    }

    protected void endBatch(boolean success) {
        this.getMainMonitor().success = success;
        this.getMainMonitor().done = true;
        this.getMainMonitor().endTime = System.currentTimeMillis();
        this.getMainMonitor().currentItem = null;
        if (this.getMainMonitor().totalWork != -1 && this.getMainMonitor().worked < this.getMainMonitor().totalWork) {
            this.getMainMonitor().worked = this.getMainMonitor().totalWork;
        }
        this.getMainMonitor().currentChildren.clear();
        this.onBatchEnd();
    }

    protected void endTask(boolean success) {
        this.done = true;
        this.currentItem = null;
        this.endTime = System.currentTimeMillis();
        this.success = success;
        if (this.parent != null) {
            this.parent.worked(this.parentWork);
            this.parent.currentChildren.remove(this);
        }
    }

    @Override
    public void fail(String reason) {
        this.fail(reason, null);
    }

    @Override
    public void fail(String reason, Throwable t) {
        this.message("Failed: " + reason + " " + (t != null ? t.getMessage() : ""));
        this.endTask(false);
        this.endBatch(false);
        this.getLogger().error("[{}] {}: FAILED ({}) , duration: {} ms", new Object[]{this.batch.getGroup(), this.batch.getName(), reason, String.valueOf(this.endTime - this.startTime), t});
        this.touch();
    }

    public IBatch getBatch() {
        return this.batch;
    }

    public Object getCurrentItem() {
        return this.currentItem;
    }

    protected Date getEndDate() {
        if (!this.done) {
            if (this.totalWork == -1) {
                return null;
            }
            long currentTime = System.currentTimeMillis();
            long elapsed = currentTime - this.startTime;
            long estEndTime = currentTime + (long)((float)((long)this.totalWork * elapsed) / this.getProgress());
            return new Date(estEndTime);
        }
        if (this.endTime != null) {
            return new Date(this.endTime);
        }
        return null;
    }

    @Override
    public long getItemCount() {
        return this.itemCount;
    }

    @Override
    public String getLastMessage() {
        return this.lastMessage;
    }

    @Override
    public Date getLastUpdate() {
        return new Date(this.getMainMonitor().lastUpdate);
    }

    protected Logger getLogger() {
        return this.getMainMonitor().logger;
    }

    protected AbstractBatchProgressMonitor getMainMonitor() {
        AbstractBatchProgressMonitor main = this;
        while (main.parent != null) {
            main = main.parent;
        }
        return main;
    }

    protected int getParentWork() {
        return this.parentWork;
    }

    @Override
    public float getProgress() {
        if (this.totalWork == -1) {
            return -1.0f;
        }
        float result = this.worked;
        for (AbstractBatchProgressMonitor child : this.currentChildren) {
            if (child.getTotalWork() == -1 || child.isDone()) continue;
            float childProgress = (float)child.getParentWork() * child.getProgress() / (float)child.getTotalWork();
            result += childProgress;
        }
        return result;
    }

    public List<String> getRejectedItems() {
        return this.rejectedItems;
    }

    protected Date getStartDate() {
        return new Date(this.startTime);
    }

    public String getTaskDescription() {
        return this.taskDescription;
    }

    public String getTaskGroup() {
        return this.taskGroup;
    }

    public String getTaskName() {
        return this.taskName;
    }

    @Override
    public int getTotalWork() {
        return this.totalWork;
    }

    @Override
    public boolean isCancelRequested() {
        return false;
    }

    public boolean isDone() {
        return this.done;
    }

    private boolean isLoggable(long lastWriteTimestamp) {
        return System.currentTimeMillis() - lastWriteTimestamp > this.writingDelay;
    }

    public boolean isSuccess() {
        return this.success;
    }

    @Override
    public void message(String message) {
        String actionName = this.name;
        if (this.name == null) {
            actionName = this.batch.getName();
        }
        this.getLogger().info("[{}] {}: {} ## {}", new Object[]{this.getBatch().getGroup(), this.getBatch().getName(), actionName, message});
        this.lastMessage = message;
        this.getMainMonitor().lastMessage = message;
        this.touch();
    }

    protected abstract IBatchProgressMonitor newInstance(int var1);

    protected void onBatchEnd() {
    }

    @Override
    public void reject(String itemId, String reason) {
        this.reject(itemId, reason, null);
    }

    @Override
    public void reject(String itemId, String reason, Throwable e) {
        this.getMainMonitor().rejectedItems.add(itemId);
        this.getLogger().warn("[{}] {}: {} rejected {} ({})", new Object[]{this.getBatch().getGroup(), this.getBatch().getName(), this.name, itemId, reason, e});
        this.touch();
    }

    @Override
    public void reject(String[] itemIds, String reason) {
        this.reject(itemIds, reason, null);
    }

    @Override
    public void reject(String[] itemIds, String reason, Throwable e) {
        if (itemIds != null) {
            for (String id : itemIds) {
                this.reject(id, reason, e);
            }
        }
    }

    @Override
    public void setCurrentItem(Object item) {
        if (this.currentItem != item) {
            ++this.getMainMonitor().itemCount;
        }
        this.currentItem = item;
        if (this.isLoggable(this.lastWriteTimestamp)) {
            this.lastWriteTimestamp = System.currentTimeMillis();
            String actionName = this.name;
            if (actionName == null) {
                actionName = this.batch.getName();
            }
            this.getLogger().info("[{}] {}: {} working on {} (#{})", new Object[]{this.getBatch().getGroup(), this.getBatch().getName(), actionName, item, this.itemCount});
        }
        this.touch();
    }

    @Override
    public void setLogger(Logger loggerParam) {
        this.getMainMonitor().logger = loggerParam;
    }

    public void setTotalWork(int totalWork) {
        if (totalWork < 0) {
            throw new IllegalArgumentException("totalWork cannot be negative : " + totalWork);
        }
        this.totalWork = totalWork;
    }

    public void setWritingDelay(long writingDelay) {
        this.writingDelay = writingDelay;
    }

    protected void touch() {
        this.getMainMonitor().lastUpdate = System.currentTimeMillis();
    }

    @Override
    public void worked(int work) {
        if (work < 0) {
            throw new IllegalArgumentException("work cannot be negative : " + work);
        }
        this.worked += work;
        if (this.totalWork != -1 && this.worked > this.totalWork) {
            this.worked = this.totalWork;
        }
        if (this.isLoggable(this.lastWriteTimestamp)) {
            float cp = this.getMainMonitor().getProgress() * 100.0f / (float)this.getMainMonitor().getTotalWork();
            this.lastWriteTimestamp = System.currentTimeMillis();
            this.getLogger().info("[{}] {}: progress {}%", new Object[]{this.getBatch().getGroup(), this.getBatch().getName(), Float.valueOf(cp)});
            if (cp > 100.0f) {
                throw new RuntimeException();
            }
        }
        this.touch();
    }
}

