/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.core.property.impl;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sf.appstatus.core.property.impl.AbstractPropertyProvider;
import org.apache.commons.lang3.time.DurationFormatUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JvmPropertyProvider
extends AbstractPropertyProvider {
    private static String readableFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "KB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    @Override
    public String getCategory() {
        return "JVM";
    }

    @Override
    public Map<String, String> getProperties() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        RuntimeMXBean RuntimemxBean = ManagementFactory.getRuntimeMXBean();
        List<String> aList = RuntimemxBean.getInputArguments();
        String parameters = "";
        for (int i = 0; i < aList.size(); ++i) {
            parameters = parameters + " " + aList.get(i);
        }
        map.put("params", parameters);
        map.put("name", RuntimemxBean.getVmName());
        map.put("vendor", RuntimemxBean.getVmVendor());
        map.put("version", RuntimemxBean.getVmVersion());
        map.put("uptime", DurationFormatUtils.formatDurationHMS((long)RuntimemxBean.getUptime()));
        Date date = new Date(RuntimemxBean.getStartTime());
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss");
        map.put("start time", sdf.format(date));
        MemoryMXBean memory = ManagementFactory.getMemoryMXBean();
        MemoryUsage heap = memory.getHeapMemoryUsage();
        map.put("memory. (heap)", JvmPropertyProvider.readableFileSize(heap.getUsed()) + "/" + JvmPropertyProvider.readableFileSize(heap.getCommitted()) + " min:" + JvmPropertyProvider.readableFileSize(heap.getInit()) + " max:" + JvmPropertyProvider.readableFileSize(heap.getMax()));
        MemoryUsage nonheap = memory.getNonHeapMemoryUsage();
        map.put("memory (non heap)", JvmPropertyProvider.readableFileSize(nonheap.getUsed()) + "/" + JvmPropertyProvider.readableFileSize(nonheap.getCommitted()) + " min:" + JvmPropertyProvider.readableFileSize(nonheap.getInit()) + " max:" + JvmPropertyProvider.readableFileSize(nonheap.getMax()));
        return map;
    }
}

