/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.core.property.impl;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import net.sf.appstatus.core.IServletContextAware;
import net.sf.appstatus.core.property.impl.AbstractPropertyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarMavenVersionProvider
extends AbstractPropertyProvider
implements IServletContextAware {
    private static final String ARTIFACT_ID = "artifactId";
    private static final String CATEGORY = "maven";
    private static final String GROUP_ID = "groupId";
    private static Logger logger = LoggerFactory.getLogger(WarMavenVersionProvider.class);
    private static final String NOT_AVAILABLE = "Not available";
    private static final String VERSION = "version";
    private ServletContext servletContext = null;

    @Override
    public String getCategory() {
        return CATEGORY;
    }

    @Override
    public Map<String, String> getProperties() {
        InputStream url = null;
        Properties pomProperties = null;
        HashMap<String, String> prop = new HashMap<String, String>();
        if (this.servletContext != null) {
            try {
                url = this.servletContext.getResourceAsStream(this.servletContext.getResourcePaths((String)this.servletContext.getResourcePaths("/META-INF/maven/").iterator().next()).iterator().next() + "pom.properties");
                if (url != null) {
                    pomProperties = new Properties();
                    pomProperties.load(url);
                    url.close();
                }
            }
            catch (Exception e) {
                logger.info("Error getting maven information from /META-INF/maven/*. Not a maven war.", (Throwable)e);
            }
            if (pomProperties == null) {
                prop.put(VERSION, NOT_AVAILABLE);
                prop.put(GROUP_ID, NOT_AVAILABLE);
                prop.put(ARTIFACT_ID, NOT_AVAILABLE);
            } else {
                prop.put(VERSION, pomProperties.getProperty(VERSION));
                prop.put(GROUP_ID, pomProperties.getProperty(GROUP_ID));
                prop.put(ARTIFACT_ID, pomProperties.getProperty(ARTIFACT_ID));
            }
        }
        return prop;
    }

    @Override
    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

