/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import net.sf.appstatus.core.IObjectInstantiationListener;
import net.sf.appstatus.core.IServletContextAware;
import net.sf.appstatus.core.IServletContextProvider;
import net.sf.appstatus.core.services.IService;
import net.sf.appstatus.core.services.IServiceManager;
import net.sf.appstatus.core.services.IServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class AppStatusServices {
    private static Logger logger = LoggerFactory.getLogger(AppStatusServices.class);
    private boolean initDone = false;
    private IObjectInstantiationListener objectInstanciationListener = null;
    private IServiceManager serviceManager = null;
    private IServletContextProvider servletContextProvider = null;

    private void checkInit() {
        if (!this.initDone) {
            logger.warn("Not initialized. Starting init");
            this.init();
        }
    }

    private Object getClassInstance(String className) {
        Object obj = null;
        if (this.objectInstanciationListener != null) {
            obj = this.objectInstanciationListener.getInstance(className);
        }
        if (obj == null) {
            try {
                obj = Class.forName(className).newInstance();
            }
            catch (ClassNotFoundException e) {
                logger.warn("Class {} not found ", (Object)className, (Object)e);
            }
            catch (InstantiationException e) {
                logger.warn("Cannot instanciate {} ", (Object)className, (Object)e);
            }
            catch (IllegalAccessException e) {
                logger.warn("Cannot access class {} for instantiation ", (Object)className, (Object)e);
            }
        }
        if (obj != null) {
            this.injectServletContext(obj);
        }
        return obj;
    }

    public IServiceMonitor getServiceMonitor(String name, String group) {
        this.checkInit();
        IService batch = null;
        if (this.serviceManager != null) {
            batch = this.serviceManager.getService(name, group);
            return this.serviceManager.getMonitor(batch);
        }
        return null;
    }

    public List<IService> getServices() {
        return this.serviceManager.getServices();
    }

    public IServletContextProvider getServletContext() {
        return this.servletContextProvider;
    }

    public synchronized void init() {
        if (this.initDone) {
            logger.warn("Already initialized");
            return;
        }
        try {
            this.loadPlugins();
        }
        catch (Exception e) {
            logger.error("Initialization error", (Throwable)e);
        }
        this.initDone = true;
    }

    private void injectServletContext(Object instance) {
        if (instance instanceof IServletContextAware && this.servletContextProvider != null) {
            ((IServletContextAware)instance).setServletContext(this.servletContextProvider.getServletContext());
        }
    }

    private void loadPlugins() {
        try {
            Enumeration<URL> plugins = AppStatusServices.class.getClassLoader().getResources("net/sf/appstatus/plugin.properties");
            while (plugins.hasMoreElements()) {
                URL url = plugins.nextElement();
                logger.info(url.toString());
                Properties p = this.loadProperties(url);
                String serviceManagerClass = p.getProperty("serviceManager");
                if (serviceManagerClass == null) continue;
                this.serviceManager = (IServiceManager)this.getClassInstance(serviceManagerClass);
            }
        }
        catch (IOException e) {
            logger.warn("Error loading plugins", (Throwable)e);
        }
    }

    private Properties loadProperties(URL url) throws IOException {
        Properties p = new Properties();
        InputStream is = url.openStream();
        p.load(is);
        is.close();
        return p;
    }

    public void setObjectInstanciationListener(IObjectInstantiationListener objectInstanciationListener) {
        this.objectInstanciationListener = objectInstanciationListener;
    }

    public void setServletContextProvider(IServletContextProvider servletContext) {
        this.servletContextProvider = servletContext;
    }
}

