/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import net.sf.appstatus.core.IObjectInstantiationListener;
import net.sf.appstatus.core.IServletContextAware;
import net.sf.appstatus.core.IServletContextProvider;
import net.sf.appstatus.core.batch.IBatch;
import net.sf.appstatus.core.batch.IBatchManager;
import net.sf.appstatus.core.batch.IBatchProgressMonitor;
import net.sf.appstatus.core.check.ICheck;
import net.sf.appstatus.core.check.ICheckResult;
import net.sf.appstatus.core.property.IPropertyProvider;
import net.sf.appstatus.core.services.IService;
import net.sf.appstatus.core.services.IServiceManager;
import net.sf.appstatus.core.services.IServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppStatus {
    private static final String CONFIG_LOCATION = "status-check.properties";
    private static Logger logger = LoggerFactory.getLogger(AppStatus.class);
    private IBatchManager batchManager = null;
    protected List<ICheck> checkers = new ArrayList<ICheck>();
    private boolean initDone = false;
    private IObjectInstantiationListener objectInstanciationListener = null;
    private List<IPropertyProvider> propertyProviders = new ArrayList<IPropertyProvider>();
    private IServiceManager serviceManager = null;
    private IServletContextProvider servletContextProvider = null;

    private void addPropertyProvider(String clazz) {
        IPropertyProvider provider = (IPropertyProvider)this.getClassInstance(clazz);
        if (provider != null) {
            this.propertyProviders.add(provider);
            logger.info("Registered property provider " + clazz);
        } else {
            logger.error("cannot instanciate class {}, Please configure \"{}\" file properly", (Object)clazz, (Object)CONFIG_LOCATION);
        }
    }

    private void addStatusChecker(String clazz) {
        ICheck check = (ICheck)this.getClassInstance(clazz);
        if (check == null) {
            logger.error("cannot instanciate class {}, Please configure \"{}\" file properly", (Object)clazz, (Object)CONFIG_LOCATION);
            return;
        }
        if (check instanceof IServletContextAware) {
            ((IServletContextAware)((Object)check)).setServletContext(this.servletContextProvider.getServletContext());
        }
        this.checkers.add(check);
        logger.info("Registered status checker " + clazz);
    }

    public List<ICheckResult> checkAll() {
        this.checkInit();
        ArrayList<ICheckResult> statusList = new ArrayList<ICheckResult>();
        for (ICheck check : this.checkers) {
            this.injectServletContext(check);
            statusList.add(check.checkStatus());
        }
        return statusList;
    }

    private void checkInit() {
        if (!this.initDone) {
            logger.warn("Not initialized. Starting init");
            this.init();
        }
    }

    public IBatchManager getBatchManager() {
        return this.batchManager;
    }

    public IBatchProgressMonitor getBatchProgressMonitor(String name, String group, String uuid) {
        this.checkInit();
        IBatch batch = null;
        if (this.batchManager != null) {
            batch = this.batchManager.addBatch(name, group, uuid);
            return this.batchManager.getMonitor(batch);
        }
        return null;
    }

    private Object getClassInstance(String className) {
        Object obj = null;
        if (this.objectInstanciationListener != null) {
            obj = this.objectInstanciationListener.getInstance(className);
        }
        if (obj == null) {
            try {
                obj = Thread.currentThread().getContextClassLoader().loadClass(className).newInstance();
            }
            catch (ClassNotFoundException e) {
                logger.warn("Class {} not found ", (Object)className, (Object)e);
            }
            catch (InstantiationException e) {
                logger.warn("Cannot instanciate {} ", (Object)className, (Object)e);
            }
            catch (IllegalAccessException e) {
                logger.warn("Cannot access class {} for instantiation ", (Object)className, (Object)e);
            }
        }
        if (obj == null) {
            try {
                obj = Class.forName(className).newInstance();
                logger.warn("Class {} loaded using a deprecated method. Please report to http://sourceforge.net/apps/mantisbt/appstatus/login_select_proj_page.php?ref=bug_report_page.php", (Object)className);
            }
            catch (ClassNotFoundException e) {
                logger.warn("Class {} not found ", (Object)className, (Object)e);
            }
            catch (InstantiationException e) {
                logger.warn("Cannot instanciate {} ", (Object)className, (Object)e);
            }
            catch (IllegalAccessException e) {
                logger.warn("Cannot access class {} for instantiation ", (Object)className, (Object)e);
            }
        }
        if (obj != null) {
            this.injectServletContext(obj);
        }
        return obj;
    }

    public Map<String, Map<String, String>> getProperties() {
        this.checkInit();
        TreeMap<String, Map<String, String>> categories = new TreeMap<String, Map<String, String>>();
        for (IPropertyProvider provider : this.propertyProviders) {
            this.injectServletContext(provider);
            if (categories.get(provider.getCategory()) == null) {
                categories.put(provider.getCategory(), new TreeMap());
            }
            Map<String, String> l = categories.get(provider.getCategory());
            l.putAll(provider.getProperties());
        }
        return categories;
    }

    @Deprecated
    public List<IBatch> getRunningBatches() {
        return this.batchManager.getRunningBatches();
    }

    public IServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public IServiceMonitor getServiceMonitor(String name, String group) {
        this.checkInit();
        IService service = null;
        if (this.serviceManager != null) {
            service = this.serviceManager.getService(name, group);
            return this.serviceManager.getMonitor(service);
        }
        return null;
    }

    public List<IService> getServices() {
        if (this.serviceManager == null) {
            return null;
        }
        return this.serviceManager.getServices();
    }

    public IServletContextProvider getServletContext() {
        return this.servletContextProvider;
    }

    public synchronized void init() {
        if (this.initDone) {
            logger.warn("Already initialized");
            return;
        }
        this.checkers = new ArrayList<ICheck>();
        this.propertyProviders = new ArrayList<IPropertyProvider>();
        try {
            Enumeration<URL> configFiles = Thread.currentThread().getContextClassLoader().getResources(CONFIG_LOCATION);
            if (configFiles == null) {
                logger.info("config file {} not found in classpath", (Object)CONFIG_LOCATION);
                return;
            }
            while (configFiles.hasMoreElements()) {
                Properties p = this.loadProperties(configFiles.nextElement());
                Set<Object> keys = p.keySet();
                for (Object oName : keys) {
                    String name = (String)oName;
                    String clazz = (String)p.get(name);
                    if (name.startsWith("check")) {
                        this.addStatusChecker(clazz);
                        continue;
                    }
                    if (name.startsWith("property")) {
                        this.addPropertyProvider(clazz);
                        continue;
                    }
                    logger.warn("unknown propery  {} : {} ", (Object)name, (Object)clazz);
                }
            }
            this.loadPlugins();
        }
        catch (Exception e) {
            logger.error("Initialization error", (Throwable)e);
        }
        this.initDone = true;
    }

    private void injectServletContext(Object instance) {
        if (instance instanceof IServletContextAware && this.servletContextProvider != null) {
            ((IServletContextAware)instance).setServletContext(this.servletContextProvider.getServletContext());
        }
    }

    private void loadPlugins() {
        int count = 0;
        try {
            Enumeration<URL> plugins = Thread.currentThread().getContextClassLoader().getResources("net/sf/appstatus/plugin.properties");
            while (plugins.hasMoreElements()) {
                String serviceManagerClass;
                URL url = plugins.nextElement();
                logger.info("AppStatus: found plugin: " + url.toString());
                Properties p = this.loadProperties(url);
                String batchManagerClass = p.getProperty("batchManager");
                if (batchManagerClass != null) {
                    this.batchManager = (IBatchManager)this.getClassInstance(batchManagerClass);
                }
                if ((serviceManagerClass = p.getProperty("serviceManager")) != null) {
                    this.serviceManager = (IServiceManager)this.getClassInstance(serviceManagerClass);
                }
                ++count;
            }
        }
        catch (IOException e) {
            logger.warn("AppStatus: Error loading plugins", (Throwable)e);
        }
        logger.info("AppStatus: found {} plugins", (Object)count);
    }

    private Properties loadProperties(URL url) throws IOException {
        Properties p = new Properties();
        InputStream is = url.openStream();
        p.load(is);
        is.close();
        return p;
    }

    public void setCheckers(List<ICheck> checkers) {
        this.checkers = checkers;
    }

    public void setObjectInstanciationListener(IObjectInstantiationListener objectInstanciationListener) {
        this.objectInstanciationListener = objectInstanciationListener;
    }

    public void setPropertyProviders(List<IPropertyProvider> propertyProviders) {
        this.propertyProviders = propertyProviders;
    }

    public void setServletContextProvider(IServletContextProvider servletContext) {
        this.servletContextProvider = servletContext;
    }
}

