/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import net.sf.appstatus.IPropertyProvider;
import net.sf.appstatus.IStatusChecker;
import net.sf.appstatus.IStatusResult;
import net.sf.appstatus.core.IObjectInstantiationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusService {
    private static final String CONFIG_LOCATION = "status-check.properties";
    private static Logger logger = LoggerFactory.getLogger(StatusService.class);
    private IObjectInstantiationListener objectInstanciationListener = null;
    private final List<IStatusChecker> probes = new ArrayList<IStatusChecker>();
    private final List<IPropertyProvider> propertyProviders = new ArrayList<IPropertyProvider>();

    public List<IStatusResult> checkAll() {
        ArrayList<IStatusResult> l = new ArrayList<IStatusResult>();
        for (IStatusChecker check : this.probes) {
            l.add(check.checkStatus());
        }
        return l;
    }

    private Object getInstance(String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Object obj = null;
        if (this.objectInstanciationListener != null) {
            obj = this.objectInstanciationListener.getInstance(className);
        }
        if (obj != null) {
            return obj;
        }
        return Class.forName(className).newInstance();
    }

    public IObjectInstantiationListener getObjectInstanciationListener() {
        return this.objectInstanciationListener;
    }

    public Map<String, Map<String, String>> getProperties() {
        TreeMap<String, Map<String, String>> categories = new TreeMap<String, Map<String, String>>();
        for (IPropertyProvider provider : this.propertyProviders) {
            if (categories.get(provider.getCategory()) == null) {
                categories.put(provider.getCategory(), new TreeMap());
            }
            Map<String, String> l = categories.get(provider.getCategory());
            l.putAll(provider.getProperties());
        }
        return categories;
    }

    public void init() {
        try {
            Enumeration<URL> configFiles = StatusService.class.getClassLoader().getResources(CONFIG_LOCATION);
            if (configFiles == null) {
                return;
            }
            URL url = null;
            Properties p = null;
            InputStream is = null;
            while (configFiles.hasMoreElements()) {
                url = configFiles.nextElement();
                p = new Properties();
                is = url.openStream();
                p.load(is);
                is.close();
                Set<Object> keys = p.keySet();
                String name = null;
                for (Object key : keys) {
                    String clazz;
                    name = (String)key;
                    if (name.startsWith("check")) {
                        clazz = (String)p.get(name);
                        IStatusChecker check = (IStatusChecker)this.getInstance(clazz);
                        this.probes.add(check);
                        logger.info("Registered status checker " + clazz);
                        continue;
                    }
                    if (!name.startsWith("property")) continue;
                    clazz = (String)p.get(name);
                    IPropertyProvider provider = (IPropertyProvider)this.getInstance(clazz);
                    this.propertyProviders.add(provider);
                    logger.info("Registered property provider " + clazz);
                }
            }
        }
        catch (Exception e) {
            logger.error("Initialization error", (Throwable)e);
        }
    }

    public void setObjectInstanciationListener(IObjectInstantiationListener objectInstanciationListener) {
        this.objectInstanciationListener = objectInstanciationListener;
    }
}

