/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.batch.jdbc;

import java.util.Collection;
import net.sf.appstatus.batch.jdbc.Batch;
import net.sf.appstatus.batch.jdbc.BatchDao;
import net.sf.appstatus.batch.jdbc.JdbcBatchManager;
import net.sf.appstatus.core.batch.AbstractBatchProgressMonitor;
import net.sf.appstatus.core.batch.IBatch;
import net.sf.appstatus.core.batch.IBatchProgressMonitor;
import net.sf.appstatus.core.batch.IBatchProgressMonitorExt;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class JdbcBatchProgressMonitor
extends AbstractBatchProgressMonitor
implements IBatchProgressMonitorExt {
    private JdbcBatchManager manager;
    BatchDao batchDao;
    private long lastDbSave;

    private JdbcBatchProgressMonitor(String executionId, JdbcBatchProgressMonitor parent, int parentWork, Batch batch, BatchDao bachDao) {
        super(executionId, (IBatchProgressMonitor)parent, parentWork, (IBatch)batch);
        this.batchDao = bachDao;
    }

    public JdbcBatchProgressMonitor(String executionId, IBatch batch, BatchDao bachDao) {
        super(executionId, batch);
        this.batchDao = bachDao;
    }

    public void done() {
        super.done();
        this.updateDb(true);
    }

    public void fail(String reason) {
        super.fail(reason);
        this.updateDb(true);
    }

    public void fail(String reason, Throwable t) {
        super.fail(reason, t);
        this.updateDb(true);
    }

    public void reject(String itemId, String reason) {
        super.reject(itemId, reason);
        this.updateDb(true);
    }

    public void reject(String[] itemIds, String reason) {
        super.reject(itemIds, reason);
        this.updateDb(true);
    }

    public void reject(String[] itemIds, String reason, Throwable e) {
        super.reject(itemIds, reason, e);
        this.updateDb(true);
    }

    public Batch getBatch() {
        return (Batch)super.getBatch();
    }

    public void beginTask(String name, String description, int totalWork) {
        super.beginTask(name, description, totalWork);
        this.updateDb(true);
    }

    protected JdbcBatchProgressMonitor getMainMonitor() {
        return (JdbcBatchProgressMonitor)super.getMainMonitor();
    }

    private boolean isLoggable(long lastWriteTimestamp) {
        return System.currentTimeMillis() - lastWriteTimestamp > this.getWritingDelay();
    }

    public void message(String message) {
        super.message(message);
        this.updateDb(true);
    }

    protected IBatchProgressMonitor newInstance(int work) {
        return new JdbcBatchProgressMonitor(this.executionId, this, work, this.getBatch(), this.batchDao);
    }

    private String readableStatus() {
        if (!this.getMainMonitor().isDone()) {
            return "running";
        }
        if (this.getMainMonitor().isSuccess()) {
            return "success";
        }
        return "failure";
    }

    public void reject(String itemId, String reason, Throwable e) {
        super.reject(itemId, reason, e);
        this.updateDb(true);
    }

    public void setCurrentItem(Object item) {
        super.setCurrentItem(item);
        this.updateDb(false);
    }

    protected void onBatchEnd() {
        this.getMainMonitor().getManager().batchEnd(this.getBatch());
    }

    private void updateDb(boolean force) {
        if (force || this.isLoggable(this.lastDbSave)) {
            try {
                this.lastDbSave = System.currentTimeMillis();
                this.getBatch().getBdBatch().setStatus(this.readableStatus());
                String dbCurrentItem = null;
                if (this.currentItem != null) {
                    String toString = this.currentItem.toString();
                    dbCurrentItem = toString.substring(0, Math.min(254, toString.length()));
                }
                this.getBatch().getBdBatch().setCurrentItem(dbCurrentItem);
                if (!StringUtils.isEmpty((CharSequence)this.getMainMonitor().getLastMessage()) && this.getMainMonitor().getLastMessage().length() > 1024) {
                    this.getBatch().getBdBatch().setLastMessage(this.getMainMonitor().getLastMessage().substring(0, 1023));
                } else {
                    this.getBatch().getBdBatch().setLastMessage(this.getMainMonitor().getLastMessage());
                }
                this.getBatch().getBdBatch().setStartDate(this.getMainMonitor().getStartDate());
                this.getBatch().getBdBatch().setEndDate(this.getMainMonitor().getEndDate());
                this.getBatch().getBdBatch().setCurrentTask(this.taskName);
                this.getBatch().getBdBatch().setProgress(Float.valueOf(this.getMainMonitor().getProgress() == -1.0f ? -1.0f : this.getMainMonitor().getProgress() * 100.0f / (float)this.getMainMonitor().getTotalWork()));
                this.getBatch().getBdBatch().setLastUpdate(this.getMainMonitor().getLastUpdate());
                this.getBatch().getBdBatch().setSuccess(this.getMainMonitor().isSuccess());
                this.getBatch().getBdBatch().setReject(org.springframework.util.StringUtils.collectionToDelimitedString((Collection)this.getMainMonitor().getRejectedItems(), (String)"|"));
                this.getBatch().getBdBatch().setItemCount(this.getMainMonitor().getItemCount());
                this.batchDao.update(this.getBatch().getBdBatch());
            }
            catch (Exception e) {
                this.getLogger().error("Error when updating batch table {}", (Object)ToStringBuilder.reflectionToString((Object)this.getBatch().getBdBatch()), (Object)e);
            }
        }
    }

    public void worked(int work) {
        super.worked(work);
        this.updateDb(false);
    }

    protected void setManager(JdbcBatchManager manager) {
        this.manager = manager;
    }

    protected JdbcBatchManager getManager() {
        return this.manager;
    }
}

