/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.batch.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.sf.appstatus.batch.jdbc.BdBatch;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchDao {
    public static final int BATCH_FETCH = 2;
    public static final int BATCH_DELETE = 3;
    public static final int BATCH_DELETE_OLD = 4;
    public static final int BATCH_DELETE_SUCCESS = 5;
    public static final int BATCH_INSERT = 6;
    public static final int BATCH_UPDATE = 7;
    public static final int BATCH_CREATE_TABLE = 1;
    public static final int BATCH_FETCH_BY_NAME = 8;
    private static Logger logger = LoggerFactory.getLogger(BatchDao.class);
    private JdbcTemplate jdbcTemplate;
    protected String tableName = "BATCH";

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public boolean createDbIfNecessary() {
        logger.info("Looking for table {}...", (Object)this.tableName);
        try {
            this.jdbcTemplate.execute("select count(*) from " + this.tableName);
            logger.info("Table {} found.", (Object)this.tableName);
            return false;
        }
        catch (DataAccessException e) {
            logger.warn("Table {} not found. Creating using \"{}\" ...", (Object)this.tableName, (Object)this.getSql(1));
            this.jdbcTemplate.execute(this.getSql(1));
            logger.info("Table {} created", (Object)this.tableName);
            return true;
        }
    }

    public void deleteBatch(String uuidBatch) {
        Object[] parameters = new Object[]{uuidBatch};
        this.jdbcTemplate.update(this.getSql(3), parameters);
        logger.info("Batch {} deleted.", (Object)uuidBatch);
    }

    public void deleteOldBatches(int delay) {
        Object[] parameters = new Object[]{new DateTime().minusMonths(delay).toDate(), "running"};
        this.jdbcTemplate.update(this.getSql(4), parameters);
        logger.info("Batchs older than {} months deleted.", (Object)delay);
    }

    public void deleteSuccessBatches() {
        Object[] parameters = new Object[]{"success"};
        this.jdbcTemplate.update(this.getSql(5), parameters);
        logger.info("Batchs with success status deleted.");
    }

    private List<BdBatch> fetchBdBatch(int max, String[] status) {
        SqlRowSet srs = this.jdbcTemplate.queryForRowSet(this.insertParametersFromList(this.getSql(2), status), new Object[]{max});
        return this.resultSet2Batches(srs);
    }

    private List<BdBatch> resultSet2Batches(SqlRowSet srs) {
        ArrayList<BdBatch> results = new ArrayList<BdBatch>();
        while (srs.next()) {
            try {
                BdBatch bdBatch = this.mappinpBdbatch(srs);
                results.add(bdBatch);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return results;
    }

    private List<BdBatch> fetchBdBatch(String group, String name, int max, String[] status) {
        ArrayList results = new ArrayList();
        SqlRowSet srs = this.jdbcTemplate.queryForRowSet(this.insertParametersFromList(this.getSql(8), status), new Object[]{group, name, max});
        return this.resultSet2Batches(srs);
    }

    private String insertParametersFromList(String sql, String[] values) {
        for (int i = 0; i < values.length; ++i) {
            values[i] = String.format("'%s'", values[i]);
        }
        return String.format(sql, StringUtils.join((Object[])values, (String)","));
    }

    public List<BdBatch> fetchError(int max) {
        List<BdBatch> results = this.fetchBdBatch(max, new String[]{"failure"});
        return results;
    }

    public List<BdBatch> fetchFinished(int max) {
        List<BdBatch> results = this.fetchBdBatch(max, new String[]{"success", "failure"});
        return results;
    }

    public List<BdBatch> fetchRunning(int max) {
        List<BdBatch> results = this.fetchBdBatch(max, new String[]{"running"});
        return results;
    }

    protected String getSql(int query) {
        switch (query) {
            case 7: {
                return "UPDATE " + this.tableName + " set ITEM = ?, CURRENT_TASK = ?, END_DATE=?, GROUP_BATCH=?,  ITEMCOUNT=?, " + "LAST_MSG = ?, UPDATED=?, NAME_BATCH=?, PROGRESS = ?, REJECT = ?, STATUS=?, " + "SUCCESS=?  WHERE  UUID_BATCH=?";
            }
            case 5: {
                return "delete from " + this.tableName + " where STATUS = ? AND REJECT ='' ";
            }
            case 3: {
                return "delete from " + this.tableName + " where UUID_BATCH = ?";
            }
            case 4: {
                return "delete from " + this.tableName + " where UPDATED < ? AND STATUS != ?";
            }
            case 6: {
                return "INSERT into " + this.tableName + " (UUID_BATCH,GROUP_BATCH,NAME_BATCH,START_DATE,STATUS,ITEMCOUNT) values (?,?,?,?,?,0)";
            }
            case 2: {
                return "SELECT UUID_BATCH, ITEM, CURRENT_TASK, END_DATE, GROUP_BATCH, ITEMCOUNT, LAST_MSG, UPDATED, NAME_BATCH, PROGRESS, REJECT, START_DATE, STATUS,SUCCESS FROM " + this.tableName + " WHERE STATUS IN ( %s ) ORDER BY UPDATED DESC LIMIT ? ";
            }
            case 8: {
                return "SELECT UUID_BATCH, ITEM, CURRENT_TASK, END_DATE, GROUP_BATCH, ITEMCOUNT, LAST_MSG, UPDATED, NAME_BATCH, PROGRESS, REJECT, START_DATE, STATUS,SUCCESS FROM " + this.tableName + " WHERE  GROUP_BATCH = ? AND NAME_BATCH = ? AND STATUS IN ( %s ) ORDER BY UPDATED DESC LIMIT ? ";
            }
            case 1: {
                return "CREATE TABLE " + this.tableName + " (" + " UUID_BATCH varchar(256) NOT NULL," + "GROUP_BATCH varchar(256) NULL," + "NAME_BATCH varchar(256) NULL," + "START_DATE DATETIME  NULL," + "END_DATE DATETIME NULL," + "UPDATED DATETIME NULL," + "STATUS varchar(64) NULL," + "SUCCESS BOOLEAN NULL," + "ITEMCOUNT BIGINT NULL," + "ITEM varchar(256) NULL," + "CURRENT_TASK varchar(256) NULL," + "PROGRESS Float NULL," + "REJECT CLOB NULL," + "LAST_MSG varchar(1024) NULL," + "PRIMARY KEY (UUID_BATCH)" + ")  ";
            }
        }
        return null;
    }

    private BdBatch mappinpBdbatch(SqlRowSet srs) throws SQLException, IOException {
        BdBatch bdBatch = new BdBatch();
        bdBatch.setUuid(srs.getString("UUID_BATCH"));
        bdBatch.setCurrentItem(srs.getString("ITEM"));
        bdBatch.setEndDate(srs.getDate("END_DATE"));
        bdBatch.setGroup(srs.getString("GROUP_BATCH"));
        bdBatch.setItemCount(srs.getLong("ITEMCOUNT"));
        bdBatch.setLastMessage(srs.getString("LAST_MSG"));
        bdBatch.setLastUpdate(srs.getDate("UPDATED"));
        bdBatch.setName(srs.getString("NAME_BATCH"));
        bdBatch.setProgress(Float.valueOf(srs.getFloat("PROGRESS")));
        bdBatch.setStartDate(srs.getDate("START_DATE"));
        bdBatch.setStatus(srs.getString("STATUS"));
        bdBatch.setSuccess(srs.getBoolean("SUCCESS"));
        Clob reject = (Clob)srs.getObject("REJECT");
        bdBatch.setReject(this.clobToString(reject));
        return bdBatch;
    }

    private String clobToString(Clob clob) throws SQLException, IOException {
        if (clob == null) {
            return null;
        }
        InputStream in = clob.getAsciiStream();
        InputStreamReader read = new InputStreamReader(in);
        StringWriter w = new StringWriter();
        int c = -1;
        while ((c = ((Reader)read).read()) != -1) {
            w.write(c);
        }
        w.flush();
        return StringUtils.trim((String)w.toString());
    }

    public BdBatch save(BdBatch bdBatch) {
        Object[] parameters = new Object[]{bdBatch.getUuid(), bdBatch.getGroup(), bdBatch.getName(), bdBatch.getStartDate(), bdBatch.getStatus()};
        logger.debug("PARAMETERS UUID BATCH:{} NAME: {} GROUP: {}", new Object[]{bdBatch.getUuid(), bdBatch.getName(), bdBatch.getGroup()});
        int result = this.jdbcTemplate.update(this.getSql(6), parameters);
        logger.debug("{} lines inserted.", (Object)result);
        return bdBatch;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public void update(BdBatch bdBatch) {
        logger.debug("Batch {} update ", (Object)bdBatch.getUuid());
        Object[] parameters = new Object[]{bdBatch.getCurrentItem(), bdBatch.getCurrentTask(), bdBatch.getEndDate(), bdBatch.getGroup(), bdBatch.getItemCount(), bdBatch.getLastMessage(), bdBatch.getLastUpdate(), bdBatch.getName(), bdBatch.getProgress(), bdBatch.getReject(), bdBatch.getStatus(), bdBatch.getSuccess(), bdBatch.getUuid()};
        this.jdbcTemplate.update(this.getSql(7), parameters);
    }

    public List<BdBatch> fetch(String group, String name, int max) {
        List<BdBatch> results = this.fetchBdBatch(group, name, max, new String[]{"success", "failure"});
        return results;
    }
}

