/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.batch.jdbc;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import net.sf.appstatus.batch.jdbc.Batch;
import net.sf.appstatus.batch.jdbc.BatchDao;
import net.sf.appstatus.batch.jdbc.BdBatch;
import net.sf.appstatus.batch.jdbc.JdbcBatchProgressMonitor;
import net.sf.appstatus.core.batch.IBatch;
import net.sf.appstatus.core.batch.IBatchManager;
import net.sf.appstatus.core.batch.IBatchProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcBatchManager
implements IBatchManager {
    private static Logger logger = LoggerFactory.getLogger(JdbcBatchManager.class);
    private BatchDao batchDao;
    List<IBatch> runningBatches = new Vector<IBatch>();
    private int logInterval;
    private int zombieInterval;

    public void setBatchDao(BatchDao batchDao) {
        this.batchDao = batchDao;
    }

    public void batchEnd(Batch batch) {
        this.runningBatches.remove(batch);
    }

    public IBatch addBatch(String name, String group, String uuid) {
        BdBatch bdBatch = new BdBatch();
        bdBatch.setName(name);
        bdBatch.setGroup(group);
        bdBatch.setUuid(uuid);
        bdBatch.setStartDate(new Date());
        bdBatch.setStatus("running");
        Batch b = new Batch(bdBatch);
        b.setZombieInterval(this.zombieInterval);
        int currentPosition = this.runningBatches.indexOf(b);
        if (currentPosition >= 0) {
            b = this.runningBatches.get(currentPosition);
        } else {
            this.runningBatches.add(b);
            this.batchDao.save(bdBatch);
        }
        return b;
    }

    private List<IBatch> convertToIBatch(List<BdBatch> bdBaches) {
        ArrayList<Batch> result = null;
        if (bdBaches != null) {
            result = new ArrayList<Batch>();
            for (BdBatch bdb : bdBaches) {
                Batch b = new Batch(bdb);
                b.setZombieInterval(this.zombieInterval);
                result.add(b);
            }
        }
        return result;
    }

    public List<IBatch> getErrorBatches() {
        return this.convertToIBatch(this.batchDao.fetchError(25));
    }

    public List<IBatch> getFinishedBatches() {
        return this.convertToIBatch(this.batchDao.fetchFinished(25));
    }

    public IBatchProgressMonitor getMonitor(IBatch batch) {
        Batch b = (Batch)batch;
        if (b.getProgressMonitor() == null) {
            JdbcBatchProgressMonitor monitor = new JdbcBatchProgressMonitor(batch.getUuid(), batch, this.batchDao);
            monitor.setManager(this);
        }
        return b.getProgressMonitor();
    }

    public List<IBatch> getRunningBatches() {
        return this.convertToIBatch(this.batchDao.fetchRunning(25));
    }

    public void removeAllBatches(int scope) {
        switch (scope) {
            case 1: {
                this.batchDao.deleteOldBatches(6);
                break;
            }
            default: {
                this.batchDao.deleteSuccessBatches();
            }
        }
    }

    public void removeBatch(String uuid) {
        this.batchDao.deleteBatch(uuid);
    }

    public void setConfiguration(Properties configuration) {
        try {
            this.logInterval = Integer.parseInt(configuration.getProperty("batch.logInterval"));
        }
        catch (NumberFormatException e) {
            this.logInterval = 1000;
        }
        logger.info("Batch log interval: {}ms", (Object)this.logInterval);
        try {
            this.zombieInterval = Integer.parseInt(configuration.getProperty("batch.zombieInterval"));
        }
        catch (NumberFormatException e) {
            this.zombieInterval = 600000;
        }
        logger.info("Zombie interval: {}", (Object)this.zombieInterval);
    }

    public Properties getConfiguration() {
        return null;
    }

    public void init() {
        this.batchDao.createDbIfNecessary();
    }

    public List<IBatch> getBatches(String group, String name) {
        return this.convertToIBatch(this.batchDao.fetch(group, name, 25));
    }
}

