/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.batch.jdbc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import net.sf.appstatus.batch.jdbc.BdBatch;
import net.sf.appstatus.batch.jdbc.JdbcBatchProgressMonitor;
import net.sf.appstatus.core.batch.IBatch;
import net.sf.appstatus.core.batch.IBatchProgressMonitor;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Batch
implements IBatch {
    BdBatch dbBatch = null;
    JdbcBatchProgressMonitor monitor;

    public Batch(BdBatch bdBatch) {
        this.dbBatch = bdBatch;
    }

    public BdBatch getBdBatch() {
        return this.dbBatch;
    }

    public String getCurrentItem() {
        return this.dbBatch.getCurrentItem();
    }

    public String getCurrentTask() {
        return this.dbBatch.getCurrentTask();
    }

    public Date getEndDate() {
        return this.dbBatch.getEndDate();
    }

    public String getGroup() {
        return this.dbBatch.getGroup();
    }

    public long getItemCount() {
        return this.dbBatch.getItemCount();
    }

    public String getLastMessage() {
        return this.dbBatch.getLastMessage();
    }

    public Date getLastUpdate() {
        return this.dbBatch.getLastUpdate();
    }

    public String getName() {
        return this.dbBatch.getName();
    }

    public IBatchProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    public float getProgressStatus() {
        return this.dbBatch.getProgress().floatValue();
    }

    public List<String> getRejectedItemsId() {
        if (this.dbBatch.getReject() == null) {
            return new ArrayList<String>();
        }
        return Arrays.asList(StringUtils.split((String)this.dbBatch.getReject(), (String)"|"));
    }

    public Date getStartDate() {
        return this.dbBatch.getStartDate();
    }

    public String getStatus() {
        return this.dbBatch.getStatus();
    }

    public String getUuid() {
        return this.dbBatch.getUuid();
    }

    public boolean isSuccess() {
        return BooleanUtils.isTrue((Boolean)this.dbBatch.getSuccess());
    }

    public void setProgressMonitor(IBatchProgressMonitor monitor) {
        this.monitor = (JdbcBatchProgressMonitor)monitor;
    }
}

