/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.batch.jdbc;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import net.sf.appstatus.batch.jdbc.Batch;
import net.sf.appstatus.batch.jdbc.BatchDao;
import net.sf.appstatus.batch.jdbc.BdBatch;
import net.sf.appstatus.batch.jdbc.JdbcBatchProgressMonitor;
import net.sf.appstatus.core.batch.IBatch;
import net.sf.appstatus.core.batch.IBatchManager;
import net.sf.appstatus.core.batch.IBatchProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcBatchManager
implements IBatchManager {
    private BatchDao batchDao;
    List<BdBatch> runningBatches = new Vector<BdBatch>();

    public void setBatchDao(BatchDao batchDao) {
        this.batchDao = batchDao;
    }

    public void batchEnd(Batch batch) {
        this.runningBatches.remove(batch);
    }

    public IBatch addBatch(String name, String group, String uuid) {
        BdBatch b = new BdBatch();
        b.setName(name);
        b.setGroup(group);
        b.setUuid(uuid);
        b.setStartDate(new Date());
        b.setStatus("running");
        int currentPosition = this.runningBatches.indexOf(b);
        if (currentPosition >= 0) {
            b = this.runningBatches.get(currentPosition);
        } else {
            this.runningBatches.add(b);
            this.batchDao.save(b);
        }
        return new Batch(b);
    }

    private List<IBatch> convertToIBatch(List<BdBatch> bdBaches) {
        ArrayList<Batch> result = null;
        if (bdBaches != null) {
            result = new ArrayList<Batch>();
            for (BdBatch b : bdBaches) {
                result.add(new Batch(b));
            }
        }
        return result;
    }

    public List<IBatch> getErrorBatches() {
        return this.convertToIBatch(this.batchDao.fetchError(25));
    }

    public List<IBatch> getFinishedBatches() {
        return this.convertToIBatch(this.batchDao.fetchFinished(25));
    }

    public IBatchProgressMonitor getMonitor(IBatch batch) {
        JdbcBatchProgressMonitor monitor = new JdbcBatchProgressMonitor(batch.getUuid(), batch, this.batchDao);
        monitor.setManager(this);
        return monitor;
    }

    public List<IBatch> getRunningBatches() {
        return this.convertToIBatch(this.batchDao.fetchRunning(25));
    }

    public void removeAllBatches(int scope) {
        switch (scope) {
            case 1: {
                this.batchDao.deleteOldBatches(6);
                break;
            }
            default: {
                this.batchDao.deleteSuccessBatches();
            }
        }
    }

    public void removeBatch(String uuid) {
        this.batchDao.deleteBatch(uuid);
    }

    public void setConfiguration(Properties configuration) {
    }

    public Properties getConfiguration() {
        return null;
    }
}

