/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.batch.jdbc;

import java.util.ArrayList;
import java.util.List;
import net.sf.appstatus.batch.jdbc.BdBatch;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchDao {
    private static Logger logger = LoggerFactory.getLogger(BatchDao.class);
    private static final String INSERT_SQL = "INSERT into BATCH (UUID_BATCH,GROUP_BATCH,NAME_BATCH,START_DATE,STATUS,ITEMCOUNT) values (?,?,?,?,?,0)";
    private static final String SQL_UPDATE = "UPDATE BATCH set ITEM = ?, CURRENT_TASK = ?, END_DATE=?, GROUP_BATCH=?,  ITEMCOUNT=?, LAST_MSG = ?, UPDATED=?, NAME_BATCH=?, PROGRESS = ?, REJECT = ?, STATUS=?, SUCCESS=?  WHERE  UUID_BATCH=?";
    private static final String SQL_BATCHS_FETCH = "SELECT UUID_BATCH, ITEM, CURRENT_TASK, END_DATE, GROUP_BATCH, ITEMCOUNT, LAST_MSG, UPDATED, NAME_BATCH, PROGRESS, REJECT, START_DATE, STATUS,SUCCESS FROM BATCH WHERE STATUS = ? ORDER BY UPDATED DESC LIMIT ?";
    private static final String SQL_DELETE = "delete from BATCH where UUID_BATCH = ?";
    private static final String SQL_DELETE_OLD_BATCH = "delete from BATCH where UPDATE =? AND STATUS != ?";
    private static final String SQL_DELETE_SUCCESS_BATCH = "delete from BATCH where STATUS != ?";
    private JdbcTemplate jdbcTemplate;

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public void deleteBatch(String uuidBatch) {
        Object[] parameters = new Object[]{uuidBatch};
        this.jdbcTemplate.update(SQL_DELETE, parameters);
        logger.info("Batch {} deleted.", (Object)uuidBatch);
    }

    public void deleteOldBatches(int delay) {
        Object[] parameters = new Object[]{new DateTime().minusMonths(delay).toDate(), "running"};
        this.jdbcTemplate.update(SQL_DELETE_OLD_BATCH, parameters);
        logger.info("Batchs older than {} months deleted.", (Object)delay);
    }

    public void deleteSuccessBatches() {
        Object[] parameters = new Object[]{"success"};
        this.jdbcTemplate.update(SQL_DELETE_SUCCESS_BATCH, parameters);
        logger.info("Batchs with success status deleted.");
    }

    public List<BdBatch> fetchError(int max) {
        List<BdBatch> results = this.fetchBdBatch(max, "failure");
        return results;
    }

    private List<BdBatch> fetchBdBatch(int max, String status) {
        ArrayList<BdBatch> results = new ArrayList<BdBatch>();
        Object[] parameters = new Object[]{status, max};
        SqlRowSet srs = this.jdbcTemplate.queryForRowSet(this.getSqlFetch(), parameters);
        while (srs.next()) {
            BdBatch bdBatch = this.mappinpBdbatch(srs);
            results.add(bdBatch);
        }
        return results;
    }

    protected String getSqlFetch() {
        return SQL_BATCHS_FETCH;
    }

    private BdBatch mappinpBdbatch(SqlRowSet srs) {
        BdBatch bdBatch = new BdBatch();
        bdBatch.setUuid(srs.getString("UUID_BATCH"));
        bdBatch.setCurrentItem(srs.getString("ITEM"));
        bdBatch.setEndDate(srs.getDate("END_DATE"));
        bdBatch.setGroup(srs.getString("GROUP_BATCH"));
        bdBatch.setItemCount(srs.getLong("ITEMCOUNT"));
        bdBatch.setLastMessage(srs.getString("LAST_MSG"));
        bdBatch.setLastUpdate(srs.getDate("UPDATED"));
        bdBatch.setName(srs.getString("NAME_BATCH"));
        bdBatch.setProgress(Float.valueOf(srs.getFloat("PROGRESS")));
        bdBatch.setReject(srs.getString("REJECT"));
        bdBatch.setStartDate(srs.getDate("START_DATE"));
        bdBatch.setStatus(srs.getString("STATUS"));
        bdBatch.setSuccess(srs.getBoolean("SUCCESS"));
        return bdBatch;
    }

    public List<BdBatch> fetchFinished(int max) {
        List<BdBatch> results = this.fetchBdBatch(max, "success");
        return results;
    }

    public List<BdBatch> fetchRunning(int max) {
        List<BdBatch> results = this.fetchBdBatch(max, "running");
        return results;
    }

    public void update(BdBatch bdBatch) {
        Object[] parameters = new Object[]{bdBatch.getCurrentItem(), bdBatch.getCurrentTask(), bdBatch.getEndDate(), bdBatch.getGroup(), bdBatch.getItemCount(), bdBatch.getLastMessage(), bdBatch.getLastUpdate(), bdBatch.getName(), bdBatch.getProgress(), bdBatch.getReject(), bdBatch.getStatus(), bdBatch.getSuccess(), bdBatch.getUuid()};
        this.jdbcTemplate.update(SQL_UPDATE, parameters);
        logger.info("Batch {} updated ", (Object)bdBatch.getUuid());
    }

    public BdBatch save(BdBatch bdBatch) {
        Object[] parameters = new Object[]{bdBatch.getUuid(), bdBatch.getGroup(), bdBatch.getName(), bdBatch.getStartDate(), bdBatch.getStatus()};
        logger.debug("PARAMETERS UUID BATCH:{} NAME: {} GROUP: {}", new Object[]{bdBatch.getUuid(), bdBatch.getName(), bdBatch.getGroup()});
        int result = this.jdbcTemplate.update(INSERT_SQL, parameters);
        logger.debug("{} lines inserted.", (Object)result);
        return bdBatch;
    }
}

