/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.batch;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sf.appstatus.batch.InProcessBatchProgressMonitor;
import net.sf.appstatus.core.batch.IBatch;
import net.sf.appstatus.core.batch.IBatchProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Batch
implements IBatch {
    private final String group;
    private InProcessBatchProgressMonitor monitor;
    private final String name;
    private final String uuid;
    private int zombieInterval = 600000;

    public Batch(String uuid) {
        this(uuid, null, null);
    }

    public Batch(String uuid, String name, String group) {
        if (uuid == null) {
            throw new IllegalArgumentException("Batch uuid cannot be null");
        }
        this.uuid = uuid;
        this.name = name;
        this.group = group;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Batch)) {
            return false;
        }
        return this.uuid.equals(((Batch)obj).getUuid());
    }

    public String getCurrentItem() {
        if (this.monitor == null) {
            return null;
        }
        Object currentItem = this.monitor.getCurrentItem();
        if (currentItem == null) {
            return null;
        }
        return currentItem.toString();
    }

    public String getCurrentTask() {
        if (this.monitor == null) {
            return null;
        }
        return this.monitor.getTaskName();
    }

    public Date getEndDate() {
        if (this.monitor == null) {
            return null;
        }
        return this.monitor.getEndDate();
    }

    public String getGroup() {
        return this.group;
    }

    public long getItemCount() {
        if (this.monitor == null) {
            return 0L;
        }
        return this.monitor.getItemCount();
    }

    public String getLastMessage() {
        if (this.monitor == null) {
            return null;
        }
        return this.monitor.getLastMessage();
    }

    public Date getLastUpdate() {
        if (this.monitor == null) {
            return null;
        }
        return this.monitor.getLastUpdate();
    }

    public String getName() {
        return this.name;
    }

    public IBatchProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    public float getProgressStatus() {
        if (this.monitor == null || this.monitor.getTotalWork() == -1 || this.monitor.getTotalWork() == 0) {
            return -1.0f;
        }
        return this.monitor.getProgress() * 100.0f / (float)this.monitor.getTotalWork();
    }

    public List<String> getRejectedItemsId() {
        if (this.monitor == null) {
            return new ArrayList<String>();
        }
        return this.monitor.getRejectedItems();
    }

    public Date getStartDate() {
        if (this.monitor == null) {
            return null;
        }
        return this.monitor.getStartDate();
    }

    public String getStatus() {
        if (this.monitor == null) {
            return null;
        }
        if (!this.monitor.isDone()) {
            if (new Date().getTime() - this.monitor.getLastUpdate().getTime() > (long)this.zombieInterval) {
                return "zombie";
            }
            return "running";
        }
        if (this.monitor.isSuccess()) {
            return "success";
        }
        return "failure";
    }

    public String getUuid() {
        return this.uuid;
    }

    public boolean isSuccess() {
        if (this.monitor == null) {
            return false;
        }
        return this.monitor.isSuccess();
    }

    public void setProgressMonitor(IBatchProgressMonitor monitor) {
        this.monitor = (InProcessBatchProgressMonitor)monitor;
    }

    public void setZombieInterval(int zombieInterval) {
        this.zombieInterval = zombieInterval;
    }
}

