/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.batch;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import net.sf.appstatus.batch.Batch;
import net.sf.appstatus.batch.InProcessBatchProgressMonitor;
import net.sf.appstatus.core.batch.IBatch;
import net.sf.appstatus.core.batch.IBatchManager;
import net.sf.appstatus.core.batch.IBatchProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InProcessBatchManager
implements IBatchManager {
    List<IBatch> errorBatches = new Vector<IBatch>();
    List<IBatch> finishedBatches = new Vector<IBatch>();
    private long maxSize = 25L;
    List<IBatch> runningBatches = new Vector<IBatch>();

    public IBatch addBatch(String name, String group, String uuid) {
        Batch b = new Batch(uuid, name, group);
        int currentPosition = this.runningBatches.indexOf(b);
        if (currentPosition >= 0) {
            b = this.runningBatches.get(currentPosition);
        } else {
            this.getMonitor(b);
            this.runningBatches.add(b);
        }
        return b;
    }

    protected void addTo(List<IBatch> l, IBatch b) {
        if ((long)l.size() >= this.maxSize) {
            l.remove(0);
        }
        l.add(b);
    }

    public void batchEnd(Batch batch) {
        this.runningBatches.remove(batch);
        this.addTo(this.finishedBatches, batch);
        if (!batch.isSuccess()) {
            this.addTo(this.errorBatches, batch);
        }
    }

    public List<IBatch> getErrorBatches() {
        return this.errorBatches;
    }

    public List<IBatch> getFinishedBatches() {
        return this.finishedBatches;
    }

    public IBatchProgressMonitor getMonitor(IBatch batch) {
        Batch b = (Batch)batch;
        if (b.getProgressMonitor() == null) {
            new InProcessBatchProgressMonitor(batch.getUuid(), batch, this);
        }
        return b.getProgressMonitor();
    }

    public List<IBatch> getRunningBatches() {
        return this.runningBatches;
    }

    public void removeAllBatches(int scope) {
        if (this.finishedBatches == null || this.finishedBatches.size() == 0) {
            return;
        }
        ArrayList<IBatch> toRemove = new ArrayList<IBatch>();
        switch (scope) {
            case 2: {
                for (IBatch b : this.finishedBatches) {
                    if (!b.isSuccess() || b.getRejectedItemsId() != null && b.getRejectedItemsId().size() != 0) continue;
                    toRemove.add(b);
                }
                break;
            }
            case 1: {
                Calendar c = Calendar.getInstance();
                c.add(2, -6);
                Date thisIsOld = c.getTime();
                for (IBatch b : this.finishedBatches) {
                    if (!b.getLastUpdate().before(thisIsOld)) continue;
                    toRemove.add(b);
                }
                break;
            }
        }
        for (IBatch b : toRemove) {
            this.removeBatch(b);
        }
    }

    private void removeBatch(IBatch b) {
        if (!this.runningBatches.contains(b)) {
            if (this.errorBatches.contains(b)) {
                this.errorBatches.remove(b);
            }
            if (this.finishedBatches.contains(b)) {
                this.finishedBatches.remove(b);
            }
        }
    }

    public void removeBatch(String uuid) {
        Batch b = new Batch(uuid);
        this.removeBatch(b);
    }

    public void setConfiguration(Properties configuration) {
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }
}

