/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.batch;

import java.util.List;
import java.util.Vector;
import net.sf.appstatus.batch.Batch;
import net.sf.appstatus.batch.InProcessBatchProgressMonitor;
import net.sf.appstatus.core.batch.IBatch;
import net.sf.appstatus.core.batch.IBatchManager;
import net.sf.appstatus.core.batch.IBatchProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InProcessBatchManager
implements IBatchManager {
    private long maxSize = 25L;
    List<IBatch> runningBatches = new Vector<IBatch>();

    public IBatch addBatch(String name, String group, String uuid) {
        if ((long)this.runningBatches.size() >= this.maxSize) {
            this.runningBatches.remove(0);
        }
        Batch b = new Batch();
        b.setName(name);
        b.setGroup(group);
        b.setUuid(uuid);
        this.runningBatches.add(b);
        return b;
    }

    public List<IBatch> getFinishedBatches() {
        return this.runningBatches;
    }

    public IBatchProgressMonitor getMonitor(IBatch batch) {
        return new InProcessBatchProgressMonitor(batch.getUuid(), batch);
    }

    public List<IBatch> getRunningBatches() {
        return this.runningBatches;
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }
}

