/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.batch;

import java.util.Date;
import java.util.List;
import net.sf.appstatus.batch.InProcessBatchProgressMonitor;
import net.sf.appstatus.core.batch.IBatch;
import net.sf.appstatus.core.batch.IBatchProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Batch
implements IBatch {
    Date endDate;
    String group;
    InProcessBatchProgressMonitor monitor;
    String name;
    String uuid;

    public String getCurrentItem() {
        return this.monitor.getCurrentItem().toString();
    }

    public String getCurrentTask() {
        return this.monitor.getTaskName();
    }

    public Date getEndDate() {
        return this.monitor.getEndDate();
    }

    public String getGroup() {
        return this.group;
    }

    public String getLastMessage() {
        return this.monitor.getLastMessage();
    }

    public Date getLastUpdate() {
        return this.monitor.getLastUpdate();
    }

    public String getName() {
        return this.name;
    }

    public IBatchProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    public float getProgressStatus() {
        if (this.monitor == null || this.monitor.getTotalWork() <= 0) {
            return -1.0f;
        }
        return this.monitor.getProgress() * 100.0f / (float)this.monitor.getTotalWork();
    }

    public List<String> getRejectedItemsId() {
        return this.monitor.getRejectedItems();
    }

    public Date getStartDate() {
        return this.monitor.getStartDate();
    }

    public String getStatus() {
        if (!this.monitor.isDone()) {
            return "running";
        }
        if (this.monitor.isSuccess()) {
            return "success";
        }
        return "failure";
    }

    public String getUuid() {
        return this.uuid;
    }

    public boolean isSuccess() {
        return this.monitor.isSuccess();
    }

    public void setGroup(String group2) {
        this.group = group2;
    }

    public void setName(String name2) {
        this.name = name2;
    }

    public void setProgressMonitor(IBatchProgressMonitor monitor) {
        this.monitor = (InProcessBatchProgressMonitor)monitor;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }
}

