/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.web.pages;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.appstatus.core.batch.IBatchManager;
import net.sf.appstatus.core.check.ICheckResult;
import net.sf.appstatus.web.IPage;
import net.sf.appstatus.web.StatusWebHandler;

public class RadiatorPage
implements IPage {
    private static final int STATUS_ERROR = 2;
    private static final int STATUS_OK = 0;
    private static final int STATUS_WARN = 1;

    public void doGet(StatusWebHandler webHandler, HttpServletRequest req, HttpServletResponse resp) throws UnsupportedEncodingException, IOException {
        resp.setContentType("text/html");
        resp.setCharacterEncoding("UTF-8");
        List results = webHandler.getAppStatus().checkAll();
        int status = 0;
        for (ICheckResult r : results) {
            if (r.getCode() != 0 && !r.isFatal() && status == 0) {
                status = 1;
            }
            if (r.getCode() == 0 || !r.isFatal()) continue;
            status = 2;
            break;
        }
        String btnClass = "btn-success";
        if (status == 1) {
            btnClass = "btn-warning";
        }
        if (status == 2) {
            btnClass = "btn-danger";
        }
        IBatchManager manager = webHandler.getAppStatus().getBatchManager();
        String batchStatus = " progress-success ";
        String active = "";
        String width = "0%";
        if (manager != null) {
            batchStatus = manager.getErrorBatches().size() > 0 ? " progress-danger " : " progress-success ";
            active = manager.getRunningBatches().size() > 0 ? " progress-striped active " : "";
            width = manager.getRunningBatches().size() + manager.getFinishedBatches().size() > 0 ? "100%" : "0%";
        }
        PrintWriter w = resp.getWriter();
        ((Writer)w).append("<html>");
        ((Writer)w).append("<head>");
        ((Writer)w).append("<meta http-equiv=\"refresh\" content=\"60;\">");
        ((Writer)w).append("<link href=\"?resource=appstatus.css\" rel=\"stylesheet\">");
        ((Writer)w).append("</head>");
        ((Writer)w).append("<body style=\"background: #000; text-align: center; padding-top: 5%;\">");
        ((Writer)w).append("<p style=\"color: #fff; font-size: 200%;\" >" + webHandler.getApplicationName() + "</p>");
        ((Writer)w).append("<p style=\" padding-top: 10%;\"><a href=\"#\" class=\"btn btn-large " + btnClass + "\" >Status</a></p>");
        ((Writer)w).append("<div class=\"progress " + batchStatus + active + "\" style=\"margin-top: 5%; width: 90%; margin-left: 5%; margin-right: 5%;\">  <div class=\"bar\" style=\"width: " + width + "%;\"></div></div>");
        ((Writer)w).append("</body></html>");
    }

    public void doPost(StatusWebHandler webHandler, HttpServletRequest req, HttpServletResponse resp) {
    }

    public String getId() {
        return "radiator";
    }

    public String getName() {
        return "Radiator";
    }
}

