/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.web.pages;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.appstatus.core.batch.IBatch;
import net.sf.appstatus.core.batch.IBatchManager;
import net.sf.appstatus.web.HtmlUtils;
import net.sf.appstatus.web.StatusWebHandler;
import net.sf.appstatus.web.pages.AbstractPage;
import org.apache.commons.lang3.text.StrBuilder;

public class BatchPage
extends AbstractPage {
    private static final String CLEAR_ITEM = "clear-item";
    private static final String CLEAR_OLD = "clear-old";
    private static final String CLEAR_SUCCESS = "clear-success";
    private static final String ENCODING = "UTF-8";
    private static final String ITEM_UUID = "item-uuid";
    private static final String PAGECONTENTLAYOUT = "batchesContentLayout.html";

    public void doGet(StatusWebHandler webHandler, HttpServletRequest req, HttpServletResponse resp) throws UnsupportedEncodingException, IOException {
        List errorBatches;
        List finishedBatches;
        this.setup(resp, "text/html");
        ServletOutputStream os = resp.getOutputStream();
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        StrBuilder sbRunningBatchesBatchesTable = new StrBuilder();
        StrBuilder sbFinishedBatchesBatchesTable = new StrBuilder();
        StrBuilder sbErrorsBatchesBatchesTable = new StrBuilder();
        IBatchManager manager = webHandler.getAppStatus().getBatchManager();
        List runningBatches = manager.getRunningBatches();
        if (HtmlUtils.generateBeginTable(sbRunningBatchesBatchesTable, runningBatches.size())) {
            HtmlUtils.generateHeaders(sbRunningBatchesBatchesTable, "", "Id", "Group", "Name", "Start", "Progress", "End (est.)", "Status", "Task", "Last Msg", "Items", "Rejected", "Last Update");
            for (IBatch batch : runningBatches) {
                HtmlUtils.generateRow(sbRunningBatchesBatchesTable, this.getIcon(batch), this.generateId(resp, batch.getUuid()), batch.getGroup(), batch.getName(), batch.getStartDate(), this.getProgressBar(batch), batch.getEndDate(), batch.getStatus(), batch.getCurrentTask(), batch.getLastMessage(), batch.getItemCount(), HtmlUtils.countAndDetail(batch.getRejectedItemsId()), batch.getLastUpdate());
            }
            HtmlUtils.generateEndTable(sbRunningBatchesBatchesTable, runningBatches.size());
        }
        if (HtmlUtils.generateBeginTable(sbFinishedBatchesBatchesTable, (finishedBatches = manager.getFinishedBatches()).size())) {
            HtmlUtils.generateHeaders(sbFinishedBatchesBatchesTable, "", "Id", "Group", "Name", "Start", "Progress", "End", "Status", "Task", "Last Msg", "Items", "Rejected", "Last Update", "");
            for (IBatch batch : finishedBatches) {
                HtmlUtils.generateRow(sbFinishedBatchesBatchesTable, this.getIcon(batch), this.generateId(resp, batch.getUuid()), batch.getGroup(), batch.getName(), batch.getStartDate(), this.getProgressBar(batch), batch.getEndDate(), batch.getStatus(), batch.getCurrentTask(), batch.getLastMessage(), batch.getItemCount(), HtmlUtils.countAndDetail(batch.getRejectedItemsId()), batch.getLastUpdate(), "<form action='?p=batch' method='post'><input type='submit' name='clear-item' value='Delete'  class='btn btn-small' /><input type=hidden name='item-uuid' value='" + batch.getUuid() + "'/></form>");
            }
            HtmlUtils.generateEndTable(sbFinishedBatchesBatchesTable, finishedBatches.size());
        }
        if (HtmlUtils.generateBeginTable(sbErrorsBatchesBatchesTable, (errorBatches = manager.getErrorBatches()).size())) {
            HtmlUtils.generateHeaders(sbErrorsBatchesBatchesTable, "", "Id", "Group", "Name", "Start", "Progress", "End", "Status", "Task", "Last Msg", "Items", "Rejected", "Last Update", "");
            for (IBatch batch : errorBatches) {
                HtmlUtils.generateRow(sbErrorsBatchesBatchesTable, this.getIcon(batch), this.generateId(resp, batch.getUuid()), batch.getGroup(), batch.getName(), batch.getStartDate(), this.getProgressBar(batch), batch.getEndDate(), batch.getStatus(), batch.getCurrentTask(), batch.getLastMessage(), batch.getItemCount(), HtmlUtils.countAndDetail(batch.getRejectedItemsId()), batch.getLastUpdate(), "<form action='?p=batch' method='post'><input type='submit' name='clear-item' value='Delete' class='btn btn-small'/><input type=hidden name='item-uuid' value='" + batch.getUuid() + "'/></form>");
            }
            HtmlUtils.generateEndTable(sbErrorsBatchesBatchesTable, errorBatches.size());
        }
        valuesMap.put("runningBatchesBatchesTable", sbRunningBatchesBatchesTable.toString());
        valuesMap.put("finishedBatchesBatchesTable", sbFinishedBatchesBatchesTable.toString());
        valuesMap.put("errorsBatchesBatchesTable", sbErrorsBatchesBatchesTable.toString());
        valuesMap.put("clearActions", this.generateClearActions());
        String content = HtmlUtils.applyLayout(valuesMap, PAGECONTENTLAYOUT);
        valuesMap.clear();
        valuesMap.put("content", content);
        os.write(this.getPage(webHandler, valuesMap).getBytes(ENCODING));
    }

    public void doPost(StatusWebHandler webHandler, HttpServletRequest req, HttpServletResponse resp) {
        if (req.getParameter(CLEAR_OLD) != null) {
            webHandler.getAppStatus().getBatchManager().removeAllBatches(1);
        } else if (req.getParameter(CLEAR_SUCCESS) != null) {
            webHandler.getAppStatus().getBatchManager().removeAllBatches(2);
        } else if (req.getParameter(CLEAR_ITEM) != null) {
            webHandler.getAppStatus().getBatchManager().removeBatch(req.getParameter(ITEM_UUID));
        }
    }

    private String generateClearActions() throws IOException {
        StrBuilder sb = new StrBuilder();
        sb.append("<p>Actions :</p><form action='?p=batch' method='post'><input type='submit' name='clear-old' value='Delete old (6 months)' class='btn'/> <input type='submit' name='clear-success' value='Delete Success w/o rejected' class='btn'/></form>");
        return sb.toString();
    }

    private String generateId(HttpServletResponse resp, String id) throws IOException {
        if (id == null) {
            return "";
        }
        if (id.length() < 15) {
            return id;
        }
        return "<span title='" + id + "'>" + id.substring(0, 10) + "...</span";
    }

    private String getIcon(IBatch b) {
        if ("failure".equals(b.getStatus())) {
            return "job-error";
        }
        if ("success".equals(b.getStatus()) && b.getRejectedItemsId() != null && b.getRejectedItemsId().size() > 0) {
            return "job-warning";
        }
        return "job";
    }

    public String getId() {
        return "batch";
    }

    public String getName() {
        return "Batch";
    }

    String getProgressBar(IBatch batch) {
        String color = "success";
        if (batch.getRejectedItemsId() != null && batch.getRejectedItemsId().size() > 0) {
            color = "warning";
        }
        if ("failure".equals(batch.getStatus())) {
            color = "danger";
        }
        int percent = Math.round(batch.getProgressStatus());
        String status = "";
        if (percent < 100) {
            status = "active progress-" + color;
        }
        if (percent == 100) {
            status = "progress-" + color;
        }
        return "<div class=\"progress progress-striped " + status + "\">" + "<div class=\"bar\" style=\"width: " + percent + "%;\"></div>" + "</div>";
    }
}

