/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.appstatus.web.pages.Resources;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.text.StrBuilder;
import org.apache.commons.lang3.text.StrSubstitutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlUtils {
    private static final String ENCODING = "UTF-8";
    private static Map<String, String> templates = new HashMap<String, String>();

    public static String applyLayout(Map<String, String> valuesMap, String templateName) throws IOException {
        String templateString = "";
        if (templates.containsKey(templateName)) {
            templateString = templates.get(templateName);
        } else {
            InputStream inputStream = Resources.class.getResourceAsStream("/templates/" + templateName);
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)inputStream, (Writer)writer, (Charset)Charset.defaultCharset());
            templateString = writer.toString();
            templates.put(templateName, templateString);
        }
        StrSubstitutor sub = new StrSubstitutor(valuesMap);
        return sub.replace(templateString);
    }

    public static String collectionToDelimitedString(Collection coll, String delim, String prefix, String suffix) {
        if (HtmlUtils.isEmpty(coll)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            sb.append(prefix).append(it.next()).append(suffix);
            if (!it.hasNext()) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    public static String countAndDetail(List<String> items) {
        String itemsList = HtmlUtils.collectionToDelimitedString(items, ", ", "", "");
        return "<a href='#' title='" + itemsList + "'>" + items.size() + "</a>" + "<span style=\"display:none\" >" + itemsList + "</span>";
    }

    public static boolean generateBeginTable(StrBuilder sb, int size) throws UnsupportedEncodingException, IOException {
        if (size == 0) {
            sb.append("<p>No items</p>");
            return false;
        }
        sb.append("<table class=\"table table-hover table-condensed\">");
        return true;
    }

    public static void generateEndTable(StrBuilder sb, int size) throws UnsupportedEncodingException, IOException {
        if (size > 0) {
            sb.append("</tbody></table>");
        }
    }

    public static void generateHeaders(StrBuilder sb, Object ... cols) throws IOException {
        sb.append("<thead><tr>");
        for (Object obj : cols) {
            sb.append("<th>");
            if (obj != null) {
                if (obj instanceof Long) {
                    Long l = (Long)obj;
                } else {
                    sb.append(obj.toString());
                }
            }
            sb.append("</th>");
        }
        sb.append("</tr></thead><tbody>");
    }

    public static void generateRow(StrBuilder sb, String status, Object ... cols) throws IOException {
        sb.append("<tr>");
        sb.append("<td class='icon'><img src='?icon=" + status + "'></td>");
        for (Object obj : cols) {
            sb.append("<td>");
            if (obj != null) {
                if (obj instanceof Date) {
                    DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2);
                    sb.append(dateFormat.format((Date)obj));
                } else {
                    sb.append(obj.toString());
                }
            }
            sb.append("</td>");
        }
        sb.append("</tr>");
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }
}

