/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.web.pages;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.appstatus.core.check.ICheckResult;
import net.sf.appstatus.web.HtmlUtils;
import net.sf.appstatus.web.StatusWebHandler;
import net.sf.appstatus.web.pages.AbstractPage;
import org.apache.commons.lang3.text.StrBuilder;

public class StatusPage
extends AbstractPage {
    private static final String ENCODING = "UTF-8";
    private static final String PAGECONTENTLAYOUT = "statusContentLayout.html";

    private static String getStatus(ICheckResult result) {
        if (result.getCode() == 0) {
            return "ok";
        }
        if (result.isFatal()) {
            return "error";
        }
        return "warn";
    }

    public void doGet(StatusWebHandler webHandler, HttpServletRequest req, HttpServletResponse resp) throws UnsupportedEncodingException, IOException {
        if (req.getParameter("json") != null) {
            this.doGetJSON(webHandler, req, resp);
        } else {
            this.doGetHTML(webHandler, req, resp);
        }
    }

    public void doGetHTML(StatusWebHandler webHandler, HttpServletRequest req, HttpServletResponse resp) throws UnsupportedEncodingException, IOException {
        this.setup(resp, "text/html");
        ServletOutputStream os = resp.getOutputStream();
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        List results = webHandler.getAppStatus().checkAll();
        Collections.sort(results);
        boolean statusOk = true;
        int statusCode = 200;
        for (ICheckResult r : results) {
            if (r.getCode() == 0 || !r.isFatal()) continue;
            resp.setStatus(500);
            statusCode = 500;
            statusOk = false;
            break;
        }
        valuesMap.put("statusOk", String.valueOf(statusOk));
        valuesMap.put("statusCode", String.valueOf(statusCode));
        StrBuilder sbStatusTable = new StrBuilder();
        if (HtmlUtils.generateBeginTable(sbStatusTable, results.size())) {
            HtmlUtils.generateHeaders(sbStatusTable, "", "Group", "Name", "Description", "Code", "Resolution");
            for (ICheckResult r : results) {
                HtmlUtils.generateRow(sbStatusTable, StatusPage.getStatus(r), r.getGroup(), r.getProbeName(), r.getDescription(), String.valueOf(r.getCode()), r.getResolutionSteps());
            }
            HtmlUtils.generateEndTable(sbStatusTable, results.size());
        }
        valuesMap.put("statusTable", sbStatusTable.toString());
        StrBuilder sbPropertiesTable = new StrBuilder();
        Map properties = webHandler.getAppStatus().getProperties();
        if (HtmlUtils.generateBeginTable(sbPropertiesTable, properties.size())) {
            HtmlUtils.generateHeaders(sbPropertiesTable, "", "Group", "Name", "Value");
            for (Map.Entry cat : properties.entrySet()) {
                String category = (String)cat.getKey();
                for (Map.Entry r : ((Map)cat.getValue()).entrySet()) {
                    HtmlUtils.generateRow(sbPropertiesTable, "prop", category, r.getKey(), r.getValue());
                }
            }
            HtmlUtils.generateEndTable(sbPropertiesTable, properties.size());
        }
        valuesMap.put("propertiesTable", sbPropertiesTable.toString());
        String content = HtmlUtils.applyLayout(valuesMap, PAGECONTENTLAYOUT);
        valuesMap.clear();
        valuesMap.put("content", content);
        os.write(this.getPage(webHandler, valuesMap).getBytes(ENCODING));
    }

    public void doGetJSON(StatusWebHandler webHandler, HttpServletRequest req, HttpServletResponse resp) throws UnsupportedEncodingException, IOException {
        this.setup(resp, "application/json");
        ServletOutputStream os = resp.getOutputStream();
        int statusCode = 200;
        List results = webHandler.getAppStatus().checkAll();
        for (ICheckResult r : results) {
            if (!r.isFatal()) continue;
            resp.setStatus(500);
            statusCode = 500;
            break;
        }
        os.write("{".getBytes(ENCODING));
        os.write(("\"code\" : " + statusCode + ",").getBytes(ENCODING));
        os.write("\"status\" : {".getBytes(ENCODING));
        boolean first = true;
        for (ICheckResult r : results) {
            if (!first) {
                os.write(",".getBytes(ENCODING));
            }
            os.write(("\"" + r.getProbeName() + "\" : " + r.getCode()).getBytes(ENCODING));
            if (!first) continue;
            first = false;
        }
        os.write("}".getBytes(ENCODING));
        os.write("}".getBytes(ENCODING));
    }

    public void doPost(StatusWebHandler webHandler, HttpServletRequest req, HttpServletResponse resp) {
    }

    public String getId() {
        return "status";
    }

    public String getName() {
        return "Status";
    }
}

