/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appstatus.web.pages;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.appstatus.web.HtmlUtils;
import net.sf.appstatus.web.IPage;
import net.sf.appstatus.web.StatusWebHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPage
implements IPage {
    private static final String ENCODING = "UTF-8";
    private static final String PAGELAYOUT = "pageLayout.html";
    private static final String URL = "http://appstatus.sourceforge.net/";

    @Override
    public abstract void doGet(StatusWebHandler var1, HttpServletRequest var2, HttpServletResponse var3) throws UnsupportedEncodingException, IOException;

    @Override
    public abstract void doPost(StatusWebHandler var1, HttpServletRequest var2, HttpServletResponse var3);

    @Override
    public String getId() {
        return null;
    }

    @Override
    public String getName() {
        return this.getId();
    }

    protected String getPage(StatusWebHandler webHandler, Map<String, String> valueMap) throws UnsupportedEncodingException, IOException {
        valueMap.put("css", "<link href=\"" + webHandler.getCssLocation() + "\" rel=\"stylesheet\">");
        valueMap.put("UrlAppStatus", URL);
        StrBuilder menu = new StrBuilder();
        for (String pageId : webHandler.getPages().keySet()) {
            IPage page = webHandler.getPages().get(pageId);
            if (StringUtils.equals((CharSequence)pageId, (CharSequence)this.getId())) {
                menu.append("<li class=active>");
            } else {
                menu.append("<li>");
            }
            menu.append("<a href=\"?p=" + page.getId() + "\">" + page.getName() + "</a></li>");
        }
        valueMap.put("menu", menu.toString());
        valueMap.put("applicationName", webHandler.getApplicationName());
        return HtmlUtils.applyLayout(valueMap, PAGELAYOUT);
    }

    protected void setup(HttpServletResponse resp, String type) throws IOException {
        resp.setContentType(type);
        resp.setCharacterEncoding(ENCODING);
    }
}

